/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.base.domain.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DomainDateUtil {
    public static final String FORMAT1 = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT2 = "yyyy-MM-dd";
    public static final String FORMAT3 = "MM/dd/yyyy HH:mm:ss";
    public static final String FORMAT4 = "MM/dd/yyyy";
    public static final String FORMAT5 = "HH:mm:ss";
    public static final String FORMAT6 = "yyyy/MM/dd";
    public static final String FORMAT7 = "yyyy-MM-dd HH:mm";
    public static final String FORMAT8 = "yyyyMMddhhmmss";
    public static SimpleDateFormat chinaDate = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    public static SimpleDateFormat chinaTime = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206");
    public static final int DATATYPE_YEAR = 1;
    public static final int DATATYPE_MONTH = 2;
    public static final int DATATYPE_DAY = 3;
    public static final int DATATYPE_HOUR = 4;
    public static final int DATATYPE_MINUTE = 5;
    public static final int DATATYPE_SECOND = 6;

    private DomainDateUtil() {
    }

    public static String getFormat(String date) throws Exception {
        String reg1 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
        String reg2 = "\\d{4}-\\d{1,2}-\\d{1,2}";
        String reg3 = "\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
        String reg4 = "\\d{1,2}/\\d{1,2}/\\d{4}";
        String reg5 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}";
        if (date.matches(reg1)) {
            return FORMAT1;
        }
        if (date.matches(reg2)) {
            return FORMAT2;
        }
        if (date.matches(reg3)) {
            return FORMAT3;
        }
        if (date.matches(reg4)) {
            return FORMAT4;
        }
        if (date.matches(reg5)) {
            return FORMAT7;
        }
        throw new Exception("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u683c\u5f0f\uff1a" + date);
    }

    public static String getCurrentDate() {
        return DomainDateUtil.getCurrentDateTime(FORMAT2);
    }

    public static String getTimestamp() {
        return DomainDateUtil.getCurrentDateTime(FORMAT8);
    }

    public static String getCurrentDate(String format) {
        return DomainDateUtil.getCurrentDateTime(format);
    }

    public static String getCurrentTime() {
        return DomainDateUtil.getCurrentDateTime(FORMAT5);
    }

    public static String getCurrentDateTime() {
        return DomainDateUtil.getCurrentDateTime(FORMAT1);
    }

    public static String getCurrentDateTime(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new Date());
    }

    public static String getYesterday() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        return df.format(c.getTime());
    }

    public static String getTomorrow() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        return df.format(c.getTime());
    }

    public static Date addDay(Date date, int day) {
        Calendar gc = DomainDateUtil.prepare(date);
        gc.add(5, day);
        return gc.getTime();
    }

    private static Calendar prepare(Date date) {
        Calendar gc = Calendar.getInstance();
        gc.setTime(date);
        return gc;
    }

    public static Date parseDate(String value) {
        java.sql.Date date = java.sql.Date.valueOf(value);
        return date;
    }
}

