import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const LinbaoInsuranceManagement = app => {
  return {
    name: '临保保险',
    icon: 'renshizhaopin',
    path: 'linbaoinsurancemanagement',
    children: [
      {
        name: '人员投保', //保险方案
        path: 'linbao-insurance-management',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/insuranceManagement/Management')
        )
      },
      
      {
        name: '保险保单',
        path: 'linbao-enterpriseinsurance',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/EnterpriseInsurance')
        )
      },
      {
        name: '', //新增线下保险记录
        title: '企业保险',
        path: 'linbao-enterpriseinsurance/insurancedetails',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Enterprise/Company/InsuranceDetails')
        )
      },
    ]
  };
};
