import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const InsuranceMart = app => {
  return {
    name: '保险商城',
    icon: 'shopping-cart',
    path: 'insurancemart',
    component: dynamicWrapper(app, ['insurance'], () =>
      import('../routes/Insurance/InsuranceMart')
    )
  };
};