"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var map = require("lodash/map");
var toPairs = require("lodash/toPairs");
function matchQueries(rules) {
    var entries = map(toPairs(rules), function (_a) {
        var className = _a[0], rule = _a[1];
        return ({
            minWidth: rule.minWidth != null ? rule.minWidth : 0,
            maxWidth: rule.maxWidth != null ? rule.maxWidth : Infinity,
            minHeight: rule.minHeight != null ? rule.minHeight : 0,
            maxHeight: rule.maxHeight != null ? rule.maxHeight : Infinity,
            className: className
        });
    });
    return function (_a) {
        var height = _a.height, width = _a.width;
        var classNameMap = {};
        for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
            var _b = entries_1[_i], className = _b.className, minWidth = _b.minWidth, maxWidth = _b.maxWidth, minHeight = _b.minHeight, maxHeight = _b.maxHeight;
            if (height != null && width != null) {
                classNameMap[className] = (minWidth <= width && width <= maxWidth &&
                    minHeight <= height && height <= maxHeight);
            }
            else if (height == null && width != null) {
                classNameMap[className] = minWidth <= width && width <= maxWidth;
            }
            else if (height != null && width == null) {
                classNameMap[className] = minHeight <= height && height <= maxHeight;
            }
            else {
                classNameMap[className] = true;
            }
        }
        return classNameMap;
    };
}
exports.default = matchQueries;
//# sourceMappingURL=matchQueries.js.map