"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = dev;

var _openBrowser = _interopRequireDefault(require("react-dev-utils/openBrowser"));

var _webpack = _interopRequireDefault(require("webpack"));

var _webpackDevServer = _interopRequireDefault(require("webpack-dev-server"));

var _chalk = _interopRequireDefault(require("chalk"));

var _WebpackDevServerUtils = require("./WebpackDevServerUtils");

var _clearConsole = _interopRequireDefault(require("./clearConsole"));

var _errorOverlayMiddleware = _interopRequireDefault(require("./errorOverlayMiddleware"));

var _send = _interopRequireWildcard(require("./send"));

var _choosePort = _interopRequireDefault(require("./choosePort"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const isInteractive = process.stdout.isTTY;
const DEFAULT_PORT = parseInt(process.env.PORT, 10) || 8000;
const HOST = process.env.HOST || '0.0.0.0';
const PROTOCOL = process.env.HTTPS ? 'https' : 'http';

const noop = () => {};

process.env.NODE_ENV = 'development';

function dev({
  cwd,
  webpackConfig,
  extraMiddlewares,
  beforeServerWithApp,
  beforeServer,
  afterServer,
  contentBase,
  onCompileDone = noop,
  onCompileInvalid = noop,
  proxy,
  openBrowser: openBrowserOpts,
  historyApiFallback = {
    disableDotRule: true
  }
}) {
  if (!webpackConfig) {
    throw new Error('必须提供 webpackConfig 配置项');
  }

  (0, _choosePort.default)(DEFAULT_PORT).then(port => {
    if (port === null) {
      return;
    }

    const urls = (0, _WebpackDevServerUtils.prepareUrls)(PROTOCOL, HOST, port);
    const compiler = (0, _WebpackDevServerUtils.createCompiler)(_webpack.default, webpackConfig, 'Your App', urls); // Webpack startup recompilation fix. Remove when @sokra fixes the bug.
    // https://github.com/webpack/webpack/issues/2983
    // https://github.com/webpack/watchpack/issues/25

    const timefix = 11000;
    compiler.plugin('watch-run', (watching, callback) => {
      watching.startTime += timefix;
      callback();
    });
    compiler.plugin('done', stats => {
      (0, _send.default)({
        type: _send.DONE
      });
      stats.startTime -= timefix;
      onCompileDone();
    });
    compiler.plugin('invalid', () => {
      (0, _send.default)({
        type: _send.COMPILING
      });
      onCompileInvalid();
    });
    const serverConfig = {
      disableHostCheck: true,
      compress: true,
      clientLogLevel: 'none',
      hot: true,
      quiet: true,
      headers: {
        'access-control-allow-origin': '*'
      },
      publicPath: webpackConfig.output.publicPath,
      watchOptions: {
        ignored: /node_modules/
      },
      historyApiFallback,
      overlay: false,
      host: HOST,
      proxy,
      https: !!process.env.HTTPS,
      contentBase: contentBase || process.env.CONTENT_BASE,

      before(app) {
        if (beforeServerWithApp) {
          beforeServerWithApp(app);
        }

        app.use((0, _errorOverlayMiddleware.default)());
      },

      after(app) {
        if (extraMiddlewares) {
          extraMiddlewares.forEach(middleware => {
            app.use(middleware);
          });
        }
      }

    };
    const devServer = new _webpackDevServer.default(compiler, serverConfig);

    if (beforeServer) {
      beforeServer(devServer);
    }

    devServer.listen(port, HOST, err => {
      if (err) {
        console.log(err);
        return;
      }

      if (isInteractive) {
        (0, _clearConsole.default)();
      }

      console.log(_chalk.default.cyan('\nStarting the development server...\n'));

      if (openBrowserOpts) {
        (0, _openBrowser.default)(urls.localUrlForBrowser);
      }

      (0, _send.default)({
        type: _send.STARTING
      });

      if (afterServer) {
        afterServer(devServer);
      }
    });
  }).catch(err => {
    console.log(err);
  });
}