/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task.cdcs;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.event.job.core.domain.BeanFactory;
import com.bcxin.event.job.core.domain.BinlogMapTranslator;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.dtos.BinlogMapDTO;
import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import java.io.IOException;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;

public class RedisOutputFormat
extends RichOutputFormat<String> {
    private static final String securityStationPersonSetKeyFormat = "baibaodunflow:tenant_station_persons:set:%s_%s";
    private static final String employeeStationSetKeyFormat = "obpm2:tenant_employee_in_stations:set:%s";
    private static final String superviseOrganizationKeyFormat = "obpm2:tenant_organizations_in_supervises:set:%s";
    private static final String employeeHSetKeyFormat = "obpm2:tenant_organizations_employees:%s";
    private static final String departmentLevelKeyFormat = "organizationauth:tlk_departmentlevel:%s";
    private static final String departmentLevelTableName = "tlk_departmentlevel";
    private static final String departmentLevelOrganizationKeySetFormat = "organizationauth:departmentlevel:set:%s";
    private static final String NUM_OF_SECURITY_MEN = "numofsecuritymen";
    private static final String NUM_OF_SECURITY_STATIONS = "numofsecuritystation";
    private final RedisConfig redisConfig;
    private JsonProvider jsonProvider;
    private CacheProvider cacheProvider;

    public RedisOutputFormat(RedisConfig redisConfig) {
        this.redisConfig = redisConfig;
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        this.jsonProvider = new JsonProviderImpl();
        this.cacheProvider = BeanFactory.getCacheProvider((RedisConfig)this.redisConfig);
    }

    public void writeRecord(String record) throws IOException {
        JSONObject data = (JSONObject)this.jsonProvider.toObject(JSONObject.class, record);
        BinlogMapDTO binlogMapDTO = BinlogMapTranslator.translate((JSONObject)data);
        this.cacheProvider.upset(binlogMapDTO);
    }

    public void close() throws IOException {
        this.cacheProvider.close();
    }
}

