/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task.cdcs;

import com.alibaba.fastjson.annotation.JSONField;
import com.bcxin.event.core.exceptions.BadEventException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class CdcSourceMeta
implements Serializable {
    private String op;
    private CoreData before;
    private CoreData after;
    private SourceData source;
    private String superviseDepartId;

    public String getServerId() {
        if (this.getSource() == null) {
            return null;
        }
        return this.getSource().getServerId();
    }

    public String getTopicKey1() {
        if (this.getSource() == null) {
            return null;
        }
        return String.format("streaming.topic.data.%s.%s", this.getDbName(), this.getTableName());
    }

    public String getDomainId() {
        if ("tenant_organizations".equalsIgnoreCase(this.getTableName()) || "tenant_companies".equalsIgnoreCase(this.getTableName())) {
            return this.getId();
        }
        String dataId = null;
        if (this.getBefore() != null && !org.springframework.util.StringUtils.hasLength((String)(dataId = this.getBefore().getDomainId()))) {
            dataId = this.getBefore().getOrganizationId();
        }
        if (StringUtils.isEmpty(dataId) && this.getAfter() != null && !org.springframework.util.StringUtils.hasLength((String)(dataId = this.getAfter().getDomainId()))) {
            dataId = this.getAfter().getOrganizationId();
        }
        return dataId;
    }

    public String getId() {
        String dataId = null;
        if (this.getBefore() != null) {
            dataId = this.getBefore().getPrimaryKeyValue();
        }
        if (StringUtils.isEmpty(dataId) && this.getAfter() != null) {
            dataId = this.getAfter().getPrimaryKeyValue();
        }
        return dataId;
    }

    public String getPartitionKey() {
        String dataId = null;
        if (this.getBefore() != null) {
            dataId = this.getBefore().getPartitionKey();
        }
        if (StringUtils.isEmpty(dataId) && this.getAfter() != null) {
            dataId = this.getAfter().getPartitionKey();
        }
        return dataId;
    }

    public String getDbName() {
        if (this.getSource() == null) {
            return null;
        }
        return this.getSource().getDbName();
    }

    public String getTableName() {
        if (this.getSource() == null) {
            return null;
        }
        return this.getSource().getTableName();
    }

    public String getFile() {
        if (this.getSource() == null) {
            return null;
        }
        return this.getSource().getFile();
    }

    public int getPos() {
        if (this.getSource() == null) {
            return 0;
        }
        return this.getSource().getPos();
    }

    public int getPartition() {
        if (this.getId() == null) {
            return 0;
        }
        int partition_Count = 3;
        int partition = Math.abs(this.getPartitionKey().hashCode()) % partition_Count;
        if (partition >= partition_Count) {
            throw new BadEventException(String.format("\u65e0\u6548\u5206\u533a\u6570\u636e:%s", partition));
        }
        return partition;
    }

    public String getOp() {
        return this.op;
    }

    public CoreData getBefore() {
        return this.before;
    }

    public CoreData getAfter() {
        return this.after;
    }

    public SourceData getSource() {
        return this.source;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void setBefore(CoreData before) {
        this.before = before;
    }

    public void setAfter(CoreData after) {
        this.after = after;
    }

    public void setSource(SourceData source) {
        this.source = source;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CdcSourceMeta)) {
            return false;
        }
        CdcSourceMeta other = (CdcSourceMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$op = this.getOp();
        String other$op = other.getOp();
        if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
            return false;
        }
        CoreData this$before = this.getBefore();
        CoreData other$before = other.getBefore();
        if (this$before == null ? other$before != null : !((Object)this$before).equals(other$before)) {
            return false;
        }
        CoreData this$after = this.getAfter();
        CoreData other$after = other.getAfter();
        if (this$after == null ? other$after != null : !((Object)this$after).equals(other$after)) {
            return false;
        }
        SourceData this$source = this.getSource();
        SourceData other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        return !(this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CdcSourceMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : $op.hashCode());
        CoreData $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        CoreData $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        SourceData $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        return result;
    }

    public String toString() {
        return "CdcSourceMeta(op=" + this.getOp() + ", before=" + this.getBefore() + ", after=" + this.getAfter() + ", source=" + this.getSource() + ", superviseDepartId=" + this.getSuperviseDepartId() + ")";
    }

    public static class SourceData {
        @JSONField(name="db")
        private String dbName;
        private String connector;
        private String name;
        @JSONField(name="table")
        private String tableName;
        @JSONField(name="server_id")
        private String serverId;
        @JSONField(name="file")
        private String file;
        @JSONField(name="pos")
        private int pos;

        public String getDbName() {
            return this.dbName;
        }

        public String getConnector() {
            return this.connector;
        }

        public String getName() {
            return this.name;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getServerId() {
            return this.serverId;
        }

        public String getFile() {
            return this.file;
        }

        public int getPos() {
            return this.pos;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public void setConnector(String connector) {
            this.connector = connector;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceData)) {
                return false;
            }
            SourceData other = (SourceData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPos() != other.getPos()) {
                return false;
            }
            String this$dbName = this.getDbName();
            String other$dbName = other.getDbName();
            if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
                return false;
            }
            String this$connector = this.getConnector();
            String other$connector = other.getConnector();
            if (this$connector == null ? other$connector != null : !this$connector.equals(other$connector)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$serverId = this.getServerId();
            String other$serverId = other.getServerId();
            if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            return !(this$file == null ? other$file != null : !this$file.equals(other$file));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SourceData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPos();
            String $dbName = this.getDbName();
            result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
            String $connector = this.getConnector();
            result = result * 59 + ($connector == null ? 43 : $connector.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $serverId = this.getServerId();
            result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            return result;
        }

        public String toString() {
            return "CdcSourceMeta.SourceData(dbName=" + this.getDbName() + ", connector=" + this.getConnector() + ", name=" + this.getName() + ", tableName=" + this.getTableName() + ", serverId=" + this.getServerId() + ", file=" + this.getFile() + ", pos=" + this.getPos() + ")";
        }
    }

    public static class CoreData {
        @JSONField(name="pk_id")
        private String pkId;
        @JSONField(name="pkId")
        private String pkId2;
        private String id;
        @JSONField(name="organization_id")
        private String organizationId;
        @JSONField(name="DOMAINID")
        private String domainId;
        @JSONField(name="tenant_user_id")
        private String tenantUserId;

        public String getPartitionKey() {
            if (!StringUtils.isEmpty((CharSequence)this.getOrganizationId()) && this.getOrganizationId().trim().length() > 1) {
                return this.getOrganizationId();
            }
            if (!StringUtils.isEmpty((CharSequence)this.getDomainId()) && this.getDomainId().trim().length() > 1) {
                return this.getDomainId();
            }
            if (!StringUtils.isEmpty((CharSequence)this.getTenantUserId()) && this.getTenantUserId().trim().length() > 1) {
                return this.getTenantUserId();
            }
            return this.getId();
        }

        public String getPrimaryKeyValue() {
            if (org.springframework.util.StringUtils.hasLength((String)this.getPkId())) {
                return this.getPkId();
            }
            if (org.springframework.util.StringUtils.hasLength((String)this.getPkId2())) {
                return this.getPkId2();
            }
            if (org.springframework.util.StringUtils.hasLength((String)this.getId())) {
                return this.getId();
            }
            return null;
        }

        public String getPkId() {
            return this.pkId;
        }

        public String getPkId2() {
            return this.pkId2;
        }

        public String getId() {
            return this.id;
        }

        public String getOrganizationId() {
            return this.organizationId;
        }

        public String getDomainId() {
            return this.domainId;
        }

        public String getTenantUserId() {
            return this.tenantUserId;
        }

        public void setPkId(String pkId) {
            this.pkId = pkId;
        }

        public void setPkId2(String pkId2) {
            this.pkId2 = pkId2;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public void setTenantUserId(String tenantUserId) {
            this.tenantUserId = tenantUserId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CoreData)) {
                return false;
            }
            CoreData other = (CoreData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$pkId = this.getPkId();
            String other$pkId = other.getPkId();
            if (this$pkId == null ? other$pkId != null : !this$pkId.equals(other$pkId)) {
                return false;
            }
            String this$pkId2 = this.getPkId2();
            String other$pkId2 = other.getPkId2();
            if (this$pkId2 == null ? other$pkId2 != null : !this$pkId2.equals(other$pkId2)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$organizationId = this.getOrganizationId();
            String other$organizationId = other.getOrganizationId();
            if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
                return false;
            }
            String this$domainId = this.getDomainId();
            String other$domainId = other.getDomainId();
            if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
                return false;
            }
            String this$tenantUserId = this.getTenantUserId();
            String other$tenantUserId = other.getTenantUserId();
            return !(this$tenantUserId == null ? other$tenantUserId != null : !this$tenantUserId.equals(other$tenantUserId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CoreData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $pkId = this.getPkId();
            result = result * 59 + ($pkId == null ? 43 : $pkId.hashCode());
            String $pkId2 = this.getPkId2();
            result = result * 59 + ($pkId2 == null ? 43 : $pkId2.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $organizationId = this.getOrganizationId();
            result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
            String $domainId = this.getDomainId();
            result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
            String $tenantUserId = this.getTenantUserId();
            result = result * 59 + ($tenantUserId == null ? 43 : $tenantUserId.hashCode());
            return result;
        }

        public String toString() {
            return "CdcSourceMeta.CoreData(pkId=" + this.getPkId() + ", pkId2=" + this.getPkId2() + ", id=" + this.getId() + ", organizationId=" + this.getOrganizationId() + ", domainId=" + this.getDomainId() + ", tenantUserId=" + this.getTenantUserId() + ")";
        }
    }
}

