/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task;

import com.bcxin.flink.cdc.kafka.source.task.ThreadContext;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.CdcDatabaseSourceProperty;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.HttpRegionSinkProperty;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.KafkaConfigProperty;
import com.bcxin.flink.streaming.cores.CoreJobContext;
import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class JobContext
implements CoreJobContext {
    private final String name;
    private final Map<String, String> flinkConfig;
    private final Collection<HttpRegionSinkProperty> httpRegionSinkProperties;
    private final CheckpointConfigProperty configProperty;
    private final KafkaConfigProperty kafkaConfigProperty;
    private final CdcDatabaseSourceProperty databaseProperty;
    private static JobContext _instance;
    private static ThreadLocal<ThreadContext> threadLocal;

    private JobContext(String name, Collection<HttpRegionSinkProperty> httpRegionSinkProperties, CdcDatabaseSourceProperty databaseProperty, CheckpointConfigProperty configProperty, KafkaConfigProperty kafkaConfigProperty) {
        this.name = name;
        this.httpRegionSinkProperties = httpRegionSinkProperties;
        this.flinkConfig = new HashMap<String, String>();
        this.configProperty = configProperty;
        this.kafkaConfigProperty = kafkaConfigProperty;
        this.databaseProperty = databaseProperty;
    }

    public void assign(HashMap<String, String> optionConfig) {
        if (MapUtils.isEmpty(optionConfig)) {
            return;
        }
        for (String key : optionConfig.keySet()) {
            this.getFlinkConfig().put(key, optionConfig.get(key));
        }
    }

    public boolean isSkipBinlogRedisCalculated() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(String name, Collection<HttpRegionSinkProperty> httpRegionSinkProperties, CdcDatabaseSourceProperty databaseProperty, CheckpointConfigProperty configProperty, KafkaConfigProperty kafkaConfigProperty) {
        if (_instance != null) return;
        Class<JobContext> clazz = JobContext.class;
        synchronized (JobContext.class) {
            if (_instance != null) return;
            _instance = new JobContext(name, httpRegionSinkProperties, databaseProperty, configProperty, kafkaConfigProperty);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void initHttpSink(String name, Collection<HttpRegionSinkProperty> httpRegionSinkProperties, CdcDatabaseSourceProperty databaseProperty, CheckpointConfigProperty configProperty) {
        JobContext.init(name, httpRegionSinkProperties, databaseProperty, configProperty, null);
    }

    public static void initKafkaSink(String name, CdcDatabaseSourceProperty databaseProperty, CheckpointConfigProperty configProperty, KafkaConfigProperty kafkaConfigProperty) {
        JobContext.init(name, null, databaseProperty, configProperty, kafkaConfigProperty);
    }

    public static JobContext getInstance() {
        if (_instance == null) {
            throw new IllegalArgumentException("\u672a\u5bf9JobContext\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c-V3");
        }
        return _instance;
    }

    public String getEnv() {
        return System.getProperty("PARAM_ENV");
    }

    public static ThreadContext getCurrentContext() {
        ThreadContext context = threadLocal.get();
        if (context == null) {
            context = new ThreadContext();
            threadLocal.set(context);
        }
        return context;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getFlinkConfig() {
        return this.flinkConfig;
    }

    public Collection<HttpRegionSinkProperty> getHttpRegionSinkProperties() {
        return this.httpRegionSinkProperties;
    }

    public CheckpointConfigProperty getConfigProperty() {
        return this.configProperty;
    }

    public KafkaConfigProperty getKafkaConfigProperty() {
        return this.kafkaConfigProperty;
    }

    public CdcDatabaseSourceProperty getDatabaseProperty() {
        return this.databaseProperty;
    }

    static {
        threadLocal = new InheritableThreadLocal<ThreadContext>();
    }
}

