package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.bcx.BcxSettle;
import com.zbkj.common.model.bcx.BcxSettleAttachments;
import com.zbkj.common.request.BcxSettleAttachmentsRequest;
import com.zbkj.common.request.BcxSettleUploadAttachmentsRequest;
import com.zbkj.common.utils.IdGeneratorSnowflake;
import com.zbkj.service.dao.BcxSettleAttachmentsDao;
import com.zbkj.service.service.BcxSettleAttachmentsService;
import com.zbkj.service.service.BcxSettleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * description: 业绩账单凭证表 服务实现类
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Service
public class BcxSettleAttachmentsServiceImpl extends ServiceImpl<BcxSettleAttachmentsDao, BcxSettleAttachments> implements BcxSettleAttachmentsService {
    
    @Resource
    private BcxSettleAttachmentsDao dao;
    @Autowired
    private BcxSettleService bcxSettleService;
    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：上传附件
     * author：linchunpeng
     * date：2023/9/6
     */
    @Override
    @Transactional
    public Boolean uploadAttachments(BcxSettleUploadAttachmentsRequest request) {
        log.info("==================上传附件==================");
        List<BcxSettleAttachments> attachmentsList = new ArrayList<>();
        Date now = new Date();
        if (CollectionUtil.isNotEmpty(request.getSettleInvoiceList())) {
            //结算发票
            for (BcxSettleAttachmentsRequest attachmentsRequest : request.getSettleInvoiceList()) {
                attachmentsList.add(createBcxSettleAttachments(request.getSettleId(), 1, attachmentsRequest, now));
            }
        }
        if (CollectionUtil.isNotEmpty(request.getSettleProofList())) {
            //结算凭证
            for (BcxSettleAttachmentsRequest attachmentsRequest : request.getSettleProofList()) {
                attachmentsList.add(createBcxSettleAttachments(request.getSettleId(), 2, attachmentsRequest, now));
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentsList)) {
            this.saveBatch(attachmentsList);
        }
        List<BcxSettleAttachments> attachments = this.findBySettleId(request.getSettleId());
        if (CollectionUtil.isNotEmpty(attachments)) {
            //判断是不是已经上传发票和凭证，如果都上传了，改一下结算单的上传状态
            if (attachments.stream().anyMatch(attachment -> attachment.getType() == 1)
                    && attachments.stream().anyMatch(attachment -> attachment.getType() == 2)) {
                BcxSettle bcxSettle = bcxSettleService.getById(request.getSettleId());
                bcxSettle.setUploadAttachments(2);
                bcxSettleService.updateById(bcxSettle);
            }
        }
        log.info("==================上传附件完成==================");
        return true;
    }

    /**
     * description：通过结算单id查询附件列表
     * author：linchunpeng
     * date：2023/9/7
     */
    @Override
    public List<BcxSettleAttachments> findBySettleId(Long settleId) {
        QueryWrapper<BcxSettleAttachments> queryWrapper = Wrappers.query();
        queryWrapper.eq("settle_id", settleId);
        return this.list(queryWrapper);
    }

    private BcxSettleAttachments createBcxSettleAttachments(Long settleId, Integer type, BcxSettleAttachmentsRequest attachmentsRequest, Date now) {
        BcxSettleAttachments attachments = new BcxSettleAttachments();
        attachments.setId(snowflake.snowflakeId());
        attachments.setSettleId(settleId);
        attachments.setType(type);
        attachments.setFileName(attachmentsRequest.getFileName());
        attachments.setExtName(attachmentsRequest.getExtName());
        attachments.setUrl(attachmentsRequest.getUrl());
        attachments.setCreateTime(now);
        attachments.setUpdateTime(now);
        return attachments;
    }
}