package com.zbkj.service.service.bcx;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxFapiaoSource;
import com.zbkj.common.model.bcx.BcxSettle;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoSourceRequest;
import com.zbkj.common.response.bcx.BcxFapiaoSourceResponse;
import com.zbkj.common.response.bcx.BcxSummaryInfo;

import java.util.List;
import java.util.Map;

/**
 * 发票源单据 服务接口
 */
public interface BcxFapiaoSourceService extends IService<BcxFapiaoSource> {

    PageInfo<BcxFapiaoSourceResponse> queryPagedList(BcxFapiaoSourceRequest request,
                                                     PageParamRequest pageParamRequest);

    Map<Integer, BcxFapiaoSource> getMapBySourceIdList(List<Integer> sourceIds);

    List<BcxFapiaoSource> queryByApplyNo(String applyNo);

    BcxSummaryInfo getSummaryInfo(BcxFapiaoSourceRequest request);

    void saveSourceFromOrder(String orderNo);

    /**
     * description：分销结算，生成开票源
     * author：linchunpeng
     * date：2024/4/12
     */
    void saveSourceFromBrokerage(BcxSettle bcxSettle);

    /**
     * description：分销撤销结算，删除未申请开票的开票源
     * author：linchunpeng
     * date：2024/4/12
     */
    void deleteSourceFromBrokerage(String settleNo);
}
