/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.validation;

import cn.hutool.core.util.StrUtil;
import com.zbkj.common.annotation.StringContains;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class StringContainsValidator
implements ConstraintValidator<StringContains, String> {
    private Set<String> limitValues;

    public void initialize(StringContains constraintAnnotation) {
        this.limitValues = Arrays.stream(constraintAnnotation.limitValues()).collect(Collectors.toSet());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return true;
        }
        return this.limitValues.contains(value.trim());
    }
}

