/*
Navicat MySQL Data Transfer

Source Server         : test_v5_qy
Source Server Version : 50731
Source Host           : 220.243.148.23:2111
Source Database       : crmeb

Target Server Type    : MYSQL
Target Server Version : 50731
File Encoding         : 65001

Date: 2023-08-15 13:50:16
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for eb_huifu_wallet
-- ----------------------------
-- DROP TABLE IF EXISTS `eb_huifu_wallet`;
CREATE TABLE `eb_huifu_wallet` (
                                   `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '服务开通主键ID',
                                   `uni_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户uid',
                                   `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                   `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                   `is_complete_open` varchar(1) DEFAULT '0' COMMENT '是否完成开通',
                                   `open_time` datetime DEFAULT NULL COMMENT '完成开通时间',
                                   `cooperate_treaty_url` varchar(200) DEFAULT NULL COMMENT '合作协议url',
                                   PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COMMENT='企业钱包服务开通';

INSERT INTO `eb_huifu_wallet` (`id`, `uni_id`, `create_time`, `update_time`, `is_complete_open`, `open_time`, `cooperate_treaty_url`) VALUES ('11', 'aSuXCEfz', '2023-08-09 17:23:11', '2023-08-10 16:45:11', '1', '2023-08-09 20:04:22', NULL);
INSERT INTO `eb_huifu_wallet` (`id`, `uni_id`, `create_time`, `update_time`, `is_complete_open`, `open_time`, `cooperate_treaty_url`) VALUES ('12', '__iZjB3As6MOfttXkZTXo', '2023-08-09 17:23:11', '2023-08-10 16:45:11', '1', '2023-08-10 20:04:22', NULL);
INSERT INTO `eb_huifu_wallet` (`id`, `uni_id`, `create_time`, `update_time`, `is_complete_open`, `open_time`, `cooperate_treaty_url`) VALUES ('13', 'iXOdYWce', '2023-08-12 17:25:32', '2023-08-12 17:27:22', '1', '2023-08-12 17:27:22', NULL);


-- ----------------------------
-- Table structure for eb_huifu_wallet_account
-- ----------------------------
-- DROP TABLE IF EXISTS `eb_huifu_wallet_account`;
CREATE TABLE `eb_huifu_wallet_account` (
                                           `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '账户基础信息主键ID',
                                           `uni_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户uid',
                                           `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                           `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                           `com_name` varchar(50) DEFAULT NULL COMMENT '公司名称',
                                           `short_name` varchar(50) DEFAULT NULL COMMENT '经营简称',
                                           `com_cer_no` varchar(50) DEFAULT NULL COMMENT '企业证件号码',
                                           `license_validity_type` varchar(2) DEFAULT NULL COMMENT '证照有效期类型:1:长期有效 0:非长期有效；',
                                           `license_begin_date` varchar(10) DEFAULT NULL COMMENT '证照有效期起始日期yyyyMMdd',
                                           `license_end_date` varchar(10) DEFAULT NULL COMMENT '证照有效期结束日期yyyyMMdd',
                                           `reg_prov_id` varchar(6) DEFAULT NULL COMMENT '注册地址(省)',
                                           `reg_area_id` varchar(6) DEFAULT NULL COMMENT '注册地址(市)',
                                           `reg_district_id` varchar(6) DEFAULT NULL COMMENT '注册地址(区)',
                                           `reg_address` varchar(200) DEFAULT NULL COMMENT '注册地址(详细信息)',
                                           `legal_rep_name` varchar(50) DEFAULT NULL COMMENT '法定代表人姓名',
                                           `idcard_type` varchar(6) DEFAULT NULL COMMENT '法人身份证件类型',
                                           `idCard_no` varchar(20) DEFAULT NULL COMMENT '法定代表人证件号码',
                                           `legal_cert_validity_type` varchar(2) DEFAULT NULL COMMENT '证照有效期类型:1:长期有效 0:非长期有效；',
                                           `legal_cert_begin_date` varchar(10) DEFAULT NULL COMMENT '身份证有效期开始日期',
                                           `legal_cert_end_date` varchar(10) DEFAULT NULL COMMENT '身份证有效期截止日期',
                                           `contact_name` varchar(50) DEFAULT NULL COMMENT '联系人姓名',
                                           `contact_phone` varchar(20) DEFAULT NULL COMMENT '联系电话',
                                           `hf_com_type` varchar(6) DEFAULT NULL COMMENT '汇付企业类型',
                                           `wallet_account_no` varchar(30) DEFAULT NULL COMMENT '钱包账户号',
                                           `frozen_amount` decimal(10,2) DEFAULT '0.00' COMMENT '冻结金额',
                                           `acct_stat` varchar(6) DEFAULT NULL COMMENT '账户状态',
                                           PRIMARY KEY (`id`) USING BTREE,
                                           KEY `index_com_wallet_account_walletAccountNo` (`wallet_account_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COMMENT='企业钱包账户基础信息';

INSERT INTO `eb_huifu_wallet_account` (`id`, `uni_id`, `create_time`, `update_time`, `com_name`, `short_name`, `com_cer_no`, `license_validity_type`, `license_begin_date`, `license_end_date`, `reg_prov_id`, `reg_area_id`, `reg_district_id`, `reg_address`, `legal_rep_name`, `idcard_type`, `idCard_no`, `legal_cert_validity_type`, `legal_cert_begin_date`, `legal_cert_end_date`, `contact_name`, `contact_phone`, `hf_com_type`, `wallet_account_no`, `frozen_amount`, `acct_stat`) VALUES ('17', 'aSuXCEfz', '2023-08-09 17:23:11', '2023-08-14 20:18:32', '陕西众合保安服务有限公司', '陕西众合保安服务有限公司', '91610102MA6U0CPG8J', '1', '20161124', '99990101', '610000', '610100', '610102', '西安市新城区新民街38号1幢1单元10803室', '李静', '00', '610502198603142850', '1', '19860314', '99990101', '李静', '13606084244', '3', '6666000137506841', '0.05', 'N');
INSERT INTO `eb_huifu_wallet_account` (`id`, `uni_id`, `create_time`, `update_time`, `com_name`, `short_name`, `com_cer_no`, `license_validity_type`, `license_begin_date`, `license_end_date`, `reg_prov_id`, `reg_area_id`, `reg_district_id`, `reg_address`, `legal_rep_name`, `idcard_type`, `idCard_no`, `legal_cert_validity_type`, `legal_cert_begin_date`, `legal_cert_end_date`, `contact_name`, `contact_phone`, `hf_com_type`, `wallet_account_no`, `frozen_amount`, `acct_stat`) VALUES ('18', '__iZjB3As6MOfttXkZTXo', '2023-08-09 17:23:11', '2023-08-10 16:44:47', '百川信（北京）信息服务有限公司', '百川信（北京）信息服务有限公司', '91350200302969730N', '0', '20140910', '20640909', '110000', '110100', '110101', '青龙胡同甲1号、3号2幢2层205-08 室', '王慧梅', '00', '622824197801040189', '0', '20190925', '20390925', '黎兴旺', '13599911340', '3', '6666000137445326', '0.00', 'N');
INSERT INTO `eb_huifu_wallet_account` (`id`, `uni_id`, `create_time`, `update_time`, `com_name`, `short_name`, `com_cer_no`, `license_validity_type`, `license_begin_date`, `license_end_date`, `reg_prov_id`, `reg_area_id`, `reg_district_id`, `reg_address`, `legal_rep_name`, `idcard_type`, `idCard_no`, `legal_cert_validity_type`, `legal_cert_begin_date`, `legal_cert_end_date`, `contact_name`, `contact_phone`, `hf_com_type`, `wallet_account_no`, `frozen_amount`, `acct_stat`) VALUES ('19', 'iXOdYWce', '2023-08-12 17:25:32', '2023-08-12 17:27:25', '众惠盾(厦门)保安服务有限公司', '众惠盾(厦门)保安服务有限公司', '91350200MA2YHM821H', '0', '20170825', '20670824', '350000', '350200', '350211', '厦门市软件园三期诚毅大街358号1604单元之一', '向小云', '00', '350204195610272038', '1', '20060116', '99990101', '洪明耀', '15980898667', '3', '6666000137685569', '0.00', 'N');


-- ----------------------------
-- Table structure for eb_huifu_wallet_account_detail
-- ----------------------------
-- DROP TABLE IF EXISTS `eb_huifu_wallet_account_detail`;
CREATE TABLE `eb_huifu_wallet_account_detail` (
                                                  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '收支明细主键ID',
                                                  `uni_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户uni_id',
                                                  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                                  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                                  `trade_date` varchar(20) DEFAULT NULL COMMENT '交易时间',
                                                  `trade_flow_no` varchar(64) DEFAULT NULL COMMENT '交易流水号',
                                                  `flow_no` varchar(64) DEFAULT NULL COMMENT '账务流水号（业务流水号）',
                                                  `accounts_deal_type` varchar(10) DEFAULT NULL COMMENT '账务处理类型',
                                                  `accounts_deal_date` varchar(20) DEFAULT NULL COMMENT '账务处理时间',
                                                  `amount` varchar(20) DEFAULT NULL COMMENT '交易金额',
                                                  `balance` varchar(20) DEFAULT NULL COMMENT '交易后余额',
                                                  `direction` varchar(10) DEFAULT NULL COMMENT '资金流向',
                                                  `hand_status` varchar(10) DEFAULT NULL COMMENT '处理状态',
                                                  `create_date` varchar(20) DEFAULT NULL COMMENT '订单创建时间',
                                                  `service_type` varchar(10) DEFAULT NULL COMMENT '服务类型',
                                                  `trade_type` varchar(10) DEFAULT NULL COMMENT '交易类型',
                                                  `account_in` varchar(30) DEFAULT NULL COMMENT '收款方账户',
                                                  `account_out` varchar(30) DEFAULT NULL COMMENT '付款方账户',
                                                  `account_in_name` varchar(100) DEFAULT NULL COMMENT '收款方账户中文',
                                                  `account_out_name` varchar(100) DEFAULT NULL COMMENT '付款方账户中文',
                                                  `memo` varchar(100) DEFAULT NULL COMMENT '备注',
                                                  `voucher_url` varchar(500) DEFAULT NULL COMMENT '电子回单url',
                                                  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COMMENT='企业钱包账户-收支明细';

INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('2', '__iZjB3As6MOfttXkZTXo', '2023-08-11 16:15:02', '2023-08-11 16:15:02', '20230810205207', '003500TOP1A230810205207P003ac139c1300000', '4540429074', '内部户处理', '20230810', '1.00', '2.00', '入账', '成功', NULL, NULL, '转账转入', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('3', '__iZjB3As6MOfttXkZTXo', '2023-08-11 16:15:02', '2023-08-11 16:15:02', '20230810205030', '003500TOP3A230810205030P128ac139c5c00000', '4540427805', '内部户处理', '20230810', '1.00', '1.00', '入账', '成功', NULL, NULL, '转账转入', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('4', '__iZjB3As6MOfttXkZTXo', '2023-08-11 16:15:02', '2023-08-11 16:15:02', '20230810183720', '00470topo1A230810183501P607ac1364ef00000', '4540000747', '内部户处理', '20230810', '0.00', '0.00', '出账', '成功', NULL, NULL, '手续费收取', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('5', '__iZjB3As6MOfttXkZTXo', '2023-08-11 16:15:02', '2023-08-11 16:15:02', '20230810183720', '00470topo1A230810183501P607ac1364ef00000', '4540000745', '内部户处理', '20230810', '8.00', '8.00', '入账', '成功', NULL, NULL, '支付收款', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('6', 'aSuXCEfz', '2023-08-11 16:15:02', '2023-08-11 16:15:02', '20230810205207', '003500TOP1A230810205207P003ac139c1300000', '4540429075', '内部户处理', '20230810', '1.00', '10.00', '出账', '成功', NULL, NULL, '转账转出', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('7', 'aSuXCEfz', '2023-08-11 16:15:02', '2023-08-11 16:15:02', '20230810205030', '003500TOP3A230810205030P128ac139c5c00000', '4540427806', '内部户处理', '20230810', '1.00', '11.00', '出账', '成功', NULL, NULL, '转账转出', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('8', 'aSuXCEfz', '2023-08-11 16:15:02', '2023-08-11 16:15:02', '20230810183720', '00470topo1A230810183501P607ac1364ef00000', '4540000746', '内部户处理', '20230810', '12.00', '12.00', '入账', '成功', NULL, NULL, '支付收款', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('58', '__iZjB3As6MOfttXkZTXo', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811170217', '003500TOP1A230811170216P876ac139c3200000', '4542082386', '内部户处理', '20230811', '0.01', '2.01', '入账', '成功', NULL, NULL, '转账转入', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('59', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811210659', '003000TOP1A230811210658P793ac139fed00000', '4542854371', '内部户处理', '20230811', '0.10', '0.89', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('60', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811205232', '003000TOP1B230811205231P508ac139d2300000', '4542808627', '内部户处理', '20230811', '1.00', '0.99', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('61', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811204039', '003000TOP3A230811204038P913ac139d2100000', '4542764080', '内部户处理', '20230811', '1.00', '1.99', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('62', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811203747', '003000TOP2B230811203747P042ac139d3100000', '4542766837', '内部户处理', '20230811', '1.00', '2.99', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('63', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811200821', '003000TOP2B230811200820P444ac139c0b00000', '4542675687', '内部户处理', '20230811', '1.00', '3.99', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('64', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811200706', '003000TOP3B230811200705P450ac139ffc00000', '4542660922', '内部户处理', '20230811', '1.00', '4.99', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('65', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811200545', '003000TOP2B230811200545P282ac139d3100000', '4542654224', '内部户处理', '20230811', '1.00', '5.99', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('66', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811193158', '003000TOP3A230811193157P388ac139d2100000', '4542546503', '内部户处理', '20230811', '1.00', '6.99', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('67', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811193132', '003000TOP2A230811193131P515ac139c0800000', '4542534938', '内部户处理', '20230811', '1.00', '7.99', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('68', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811170217', '003500TOP1A230811170216P876ac139c3200000', '4542082387', '内部户处理', '20230811', '0.01', '8.99', '出账', '成功', NULL, NULL, '转账转出', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `eb_huifu_wallet_account_detail` (`id`, `uni_id`, `create_time`, `update_time`, `trade_date`, `trade_flow_no`, `flow_no`, `accounts_deal_type`, `accounts_deal_date`, `amount`, `balance`, `direction`, `hand_status`, `create_date`, `service_type`, `trade_type`, `account_in`, `account_out`, `account_in_name`, `account_out_name`, `memo`, `voucher_url`) VALUES ('69', 'aSuXCEfz', '2023-08-12 10:59:56', '2023-08-12 10:59:56', '20230811154325', '003000TOP2A230811154325P140ac139ced00000', '4541917587', '内部户处理', '20230811', '1.00', '9.00', '出账', '成功', NULL, NULL, '取现', NULL, NULL, NULL, NULL, NULL, NULL);


-- ----------------------------
-- Table structure for eb_huifu_wallet_busi
-- ----------------------------
-- DROP TABLE IF EXISTS `eb_huifu_wallet_busi`;
CREATE TABLE `eb_huifu_wallet_busi` (
                                        `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '账户业务入驻主键ID',
                                        `account_id` int(10) NOT NULL DEFAULT '0' COMMENT '账户基础信息id',
                                        `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                        `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                        `req_seq_id` varchar(32) DEFAULT NULL COMMENT '流水号',
                                        `wallet_account_no` varchar(30) DEFAULT NULL COMMENT '钱包账户号',
                                        `mp` varchar(20) DEFAULT NULL COMMENT '银行卡绑定手机号',
                                        `cash_type` varchar(6) DEFAULT NULL COMMENT '业务类型 D1：下一自然日到银行账户 D0：当日到银行账户',
                                        `card_type` varchar(2) DEFAULT NULL COMMENT '卡类型：对公，1：对私，2：对私非法人',
                                        `card_name` varchar(128) DEFAULT NULL COMMENT '卡户名',
                                        `card_no` varchar(32) DEFAULT NULL COMMENT '卡号',
                                        `prov_id` varchar(6) DEFAULT NULL COMMENT '银行所在省',
                                        `area_id` varchar(6) DEFAULT NULL COMMENT '银行所在市',
                                        `bank_code` varchar(8) DEFAULT NULL COMMENT '银行号',
                                        `branch_code` varchar(12) DEFAULT NULL COMMENT '支行联行号',
                                        `branch_name` varchar(64) DEFAULT NULL COMMENT '支行名称',
                                        `token_no` varchar(20) DEFAULT NULL COMMENT '取现卡序列号',
                                        PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COMMENT='企业钱包账户业务入驻';

INSERT INTO `eb_huifu_wallet_busi` (`id`, `account_id`, `create_time`, `update_time`, `req_seq_id`, `wallet_account_no`, `mp`, `cash_type`, `card_type`, `card_name`, `card_no`, `prov_id`, `area_id`, `bank_code`, `branch_code`, `branch_name`, `token_no`) VALUES ('3', '17', '2023-08-09 20:04:22', '2023-08-11 14:30:48', '202308092004198009w0kz2fgtfzh96', NULL, NULL, 'D1', '0', '陕西众合保安服务有限公司', '3700020509245218394', '610000', '610100', '1020000', '102791000195', '工行陕西省西安北关支行', '10032533917');
INSERT INTO `eb_huifu_wallet_busi` (`id`, `account_id`, `create_time`, `update_time`, `req_seq_id`, `wallet_account_no`, `mp`, `cash_type`, `card_type`, `card_name`, `card_no`, `prov_id`, `area_id`, `bank_code`, `branch_code`, `branch_name`, `token_no`) VALUES ('4', '18', '2023-08-09 20:04:22', '2023-08-11 14:30:52', NULL, NULL, NULL, 'T1', '0', '百川信（北京）信息服务有限公司', '0200053419200063402', '110000', '110100', '1050000', '105100010037', '中国建设银行北京呼家楼支行', '10032484976');
INSERT INTO `eb_huifu_wallet_busi` (`id`, `account_id`, `create_time`, `update_time`, `req_seq_id`, `wallet_account_no`, `mp`, `cash_type`, `card_type`, `card_name`, `card_no`, `prov_id`, `area_id`, `bank_code`, `branch_code`, `branch_name`, `token_no`) VALUES ('5', '19', '2023-08-12 17:27:22', '2023-08-12 17:27:22', '20230812172720809vn36stvdsgldh3', NULL, NULL, 'D1', '0', '众惠盾(厦门)保安服务有限公司', '35150198540100000484', '350000', '350200', '1050000', '105393000499', '中国建设银行股份有限公司厦门滨东支行', '10032671586');


-- ----------------------------
-- Table structure for eb_huifu_wallet_process
-- ----------------------------
-- DROP TABLE IF EXISTS `eb_huifu_wallet_process`;
CREATE TABLE `eb_huifu_wallet_process` (
                                           `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '开户流程主键ID',
                                           `uni_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户uni_id',
                                           `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                           `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                           `step` int(4) NOT NULL COMMENT '第几步',
                                           `description` varchar(30) DEFAULT NULL COMMENT '描述',
                                           `is_complete` varchar(1) DEFAULT NULL COMMENT '是否完成',
                                           PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COMMENT='企业钱包开户流程';

INSERT INTO `eb_huifu_wallet_process` (`id`, `uni_id`, `create_time`, `update_time`, `step`, `description`, `is_complete`) VALUES ('16', 'aSuXCEfz', '2023-08-09 14:23:11', '2023-08-09 14:45:23', '1', '企业基本信息录入', '1');
INSERT INTO `eb_huifu_wallet_process` (`id`, `uni_id`, `create_time`, `update_time`, `step`, `description`, `is_complete`) VALUES ('17', 'aSuXCEfz', '2023-08-09 17:23:11', '2023-08-10 16:45:23', '2', '账户业务入驻', '1');
INSERT INTO `eb_huifu_wallet_process` (`id`, `uni_id`, `create_time`, `update_time`, `step`, `description`, `is_complete`) VALUES ('18', '__iZjB3As6MOfttXkZTXo', '2023-08-09 14:23:11', '2023-08-09 14:45:23', '1', '企业基本信息录入', '1');
INSERT INTO `eb_huifu_wallet_process` (`id`, `uni_id`, `create_time`, `update_time`, `step`, `description`, `is_complete`) VALUES ('19', '__iZjB3As6MOfttXkZTXo', '2023-08-09 17:23:11', '2023-08-10 16:45:23', '2', '账户业务入驻', '1');
INSERT INTO `eb_huifu_wallet_process` (`id`, `uni_id`, `create_time`, `update_time`, `step`, `description`, `is_complete`) VALUES ('20', 'iXOdYWce', '2023-08-12 17:25:32', '2023-08-12 17:25:32', '1', '企业基本信息录入', '1');
INSERT INTO `eb_huifu_wallet_process` (`id`, `uni_id`, `create_time`, `update_time`, `step`, `description`, `is_complete`) VALUES ('21', 'iXOdYWce', '2023-08-12 17:25:32', '2023-08-15 13:55:03', '2', '账户业务入驻', '1');


-- ----------------------------
-- Table structure for eb_huifu_wallet_reconciliation
-- ----------------------------
-- DROP TABLE IF EXISTS `eb_huifu_wallet_reconciliation`;
CREATE TABLE `eb_huifu_wallet_reconciliation` (
                                                  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '对账主键ID',
                                                  `trade_serial_no` varchar(64) NOT NULL COMMENT '交易流水号',
                                                  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                                  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                                  `merchant_no` varchar(30) DEFAULT NULL COMMENT '商户号',
                                                  `trade_date` varchar(10) DEFAULT NULL COMMENT '交易日期',
                                                  `request_serial_no` varchar(64) DEFAULT NULL COMMENT '请求流水号',
                                                  `trade_amount` decimal(14,2) DEFAULT NULL COMMENT '交易金额',
                                                  `trade_status` varchar(6) DEFAULT NULL COMMENT '交易状态',
                                                  `bank_trade_type` varchar(6) DEFAULT NULL COMMENT '银行交易类型',
                                                  `trade_start_time` varchar(20) DEFAULT NULL COMMENT '交易订单创建时间',
                                                  `trade_end_time` varchar(20) DEFAULT NULL COMMENT '交易订单完成时间',
                                                  `expend_account_no` varchar(30) DEFAULT NULL COMMENT '出账方账号',
                                                  `expend_account_name` varchar(30) DEFAULT NULL COMMENT '出账方户名',
                                                  `expend_bank_code` varchar(20) DEFAULT NULL COMMENT '出账方银行编码',
                                                  `income_account_no` varchar(30) DEFAULT NULL COMMENT '入账方账号',
                                                  `income_account_name` varchar(30) DEFAULT NULL COMMENT '入账方户名',
                                                  `incomed_bank_code` varchar(20) DEFAULT NULL COMMENT '入账方银行编码',
                                                  `income_cer_no` varchar(50) DEFAULT NULL COMMENT '入账方卡号',
                                                  `merchant_retain` varchar(50) DEFAULT NULL COMMENT '商户保留域',
                                                  `remark` varchar(200) DEFAULT NULL COMMENT '交易备注',
                                                  `service_charge` varchar(100) DEFAULT NULL COMMENT '手续费',
                                                  `expend_uni_id` varchar(32) NOT NULL DEFAULT '' COMMENT '出账用户uni_id',
                                                  `income_uni_id` varchar(32) NOT NULL DEFAULT '' COMMENT '入账用户uni_id',
                                                  PRIMARY KEY (`id`) USING BTREE,
                                                  KEY `index_com_wallet_reconciliation_expendAccountNo` (`expend_account_no`) USING BTREE,
                                                  KEY `index_com_wallet_reconciliation_incomeAccountNo` (`income_account_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='企业钱包对账';

INSERT INTO `eb_huifu_wallet_reconciliation` (`id`, `trade_serial_no`, `create_time`, `update_time`, `merchant_no`, `trade_date`, `request_serial_no`, `trade_amount`, `trade_status`, `bank_trade_type`, `trade_start_time`, `trade_end_time`, `expend_account_no`, `expend_account_name`, `expend_bank_code`, `income_account_no`, `income_account_name`, `incomed_bank_code`, `income_cer_no`, `merchant_retain`, `remark`, `service_charge`, `expend_uni_id`, `income_uni_id`) VALUES ('1', '003500TOP1A230810205207P003ac139c1300000', '2023-08-11 17:41:19', '2023-08-11 19:16:46', NULL, '20230810', '300000', '1.00', '1', NULL, '20230810', '20230810', '6666000137506841', '陕西众合保安服务有限公司', '102791000195', '6666000137445326', '百川信（北京）信息服务有限公司', '105100010037', NULL, '购买产品', NULL, NULL, 'aSuXCEfz', '__iZjB3As6MOfttXkZTXo');
INSERT INTO `eb_huifu_wallet_reconciliation` (`id`, `trade_serial_no`, `create_time`, `update_time`, `merchant_no`, `trade_date`, `request_serial_no`, `trade_amount`, `trade_status`, `bank_trade_type`, `trade_start_time`, `trade_end_time`, `expend_account_no`, `expend_account_name`, `expend_bank_code`, `income_account_no`, `income_account_name`, `incomed_bank_code`, `income_cer_no`, `merchant_retain`, `remark`, `service_charge`, `expend_uni_id`, `income_uni_id`) VALUES ('2', '003500TOP1A230810205207P003ac139c1300001', '2023-08-11 17:41:19', '2023-08-11 19:16:49', '', '20230810', '300001', '8.00', '1', '', '20230810', '20230810', '6666000137506841', '陕西众合保安服务有限公司', '102791000195', '6666000137445326', '百川信（北京）信息服务有限公司', '105100010037', '', '购买产品', '', '', 'aSuXCEfz', '__iZjB3As6MOfttXkZTXo');


-- ----------------------------
-- Table structure for eb_huifu_wallet_trade
-- ----------------------------
-- DROP TABLE IF EXISTS `eb_huifu_wallet_trade`;
CREATE TABLE `eb_huifu_wallet_trade` (
                                         `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '账户交易记录主键ID',
                                         `uni_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户uni_id',
                                         `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                         `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                         `req_seq_id` varchar(32) DEFAULT NULL COMMENT '请求流水号',
                                         `hf_seq_id` varchar(64) DEFAULT NULL COMMENT '全局流水号',
                                         `expend_account_no` varchar(32) DEFAULT NULL COMMENT '出账方商户号',
                                         `income_account_no` varchar(32) DEFAULT NULL COMMENT '入账方商户号',
                                         `amount` decimal(10,2) DEFAULT NULL COMMENT '金额',
                                         `good_desc` varchar(256) DEFAULT NULL COMMENT '商品描述',
                                         `remark` varchar(256) DEFAULT NULL COMMENT '备注',
                                         `trade_status` varchar(6) DEFAULT NULL COMMENT '交易状态',
                                         `trans_finish_time` timestamp NULL DEFAULT NULL COMMENT '交易完成时间',
                                         `business_partner_seq` varchar(60) DEFAULT NULL COMMENT '业务交易流水号',
                                         `business_code` varchar(20) DEFAULT NULL COMMENT '业务编码',
                                         `trade_type` varchar(255) DEFAULT NULL COMMENT '校验类型',
                                         `error_msg` varchar(255) DEFAULT NULL COMMENT '失败原因',
                                         PRIMARY KEY (`id`) USING BTREE,
                                         KEY `index_com_wallet_trade_uni_id` (`uni_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COMMENT='企业钱包账户交易记录';

INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('3', 'aSuXCEfz', '2023-08-10 20:51:59', '2023-08-10 20:52:07', '20230810205159799wlwayzstn708st', '003500TOP1A230810205207P003ac139c1300000', '6666000137506841', '6666000137445326', '0.00', NULL, NULL, '1', '2023-08-10 20:52:07', '20230810203741630', '01001', '03', NULL);
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('4', 'aSuXCEfz', '2023-08-10 20:51:59', '2023-08-10 20:52:07', '20230810205159799wlwayzstn708st', '003500TOP1A230810205207P003ac139c1300000', '6666000137506841', '6666000137445326', '0.00', NULL, NULL, '1', '2023-08-10 20:52:07', '20230810203741630', '01001', '03', NULL);
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('5', 'aSuXCEfz', '2023-08-11 17:02:16', '2023-08-11 17:02:17', '20230811170216526k69gyy66ggk4ok', '003500TOP1A230811170216P876ac139c3200000', '6666000137506841', '6666000137445326', '0.01', NULL, NULL, '1', '2023-08-11 17:02:17', 'PT660169174453337142296', '1', '03', NULL);
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('6', 'aSuXCEfz', '2023-08-11 19:31:31', '2023-08-11 19:31:31', '202308111931312022j37mg8v9u9e0t', '003000TOP2A230811193131P515ac139c0800000', '6666000137506841', NULL, '1.00', NULL, NULL, '0', '2023-08-11 00:00:00', NULL, NULL, '02', '受理成功');
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('7', 'aSuXCEfz', '2023-08-11 19:31:57', '2023-08-11 19:31:57', '20230811193157083brroxat176tydd', '003000TOP3A230811193157P388ac139d2100000', '6666000137506841', NULL, '1.00', NULL, NULL, '0', '2023-08-11 00:00:00', NULL, NULL, '02', '受理成功');
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('8', 'aSuXCEfz', '2023-08-11 20:05:45', '2023-08-11 20:05:45', '20230811200544957ypr7o2votrn2se', '003000TOP2B230811200545P282ac139d3100000', '6666000137506841', NULL, '1.00', NULL, NULL, '0', '2023-08-11 00:00:00', NULL, NULL, '02', '受理成功');
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('9', 'aSuXCEfz', '2023-08-11 20:07:05', '2023-08-11 20:07:05', '20230811200705110y0u38sx53b5xal', '003000TOP3B230811200705P450ac139ffc00000', '6666000137506841', NULL, '1.00', NULL, NULL, '0', '2023-08-11 00:00:00', NULL, NULL, '02', '受理成功');
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('10', 'aSuXCEfz', '2023-08-11 20:08:20', '2023-08-11 20:08:20', '20230811200820132sswzb272nj2wi0', '003000TOP2B230811200820P444ac139c0b00000', '6666000137506841', NULL, '1.00', NULL, NULL, '0', '2023-08-11 00:00:00', NULL, NULL, '02', '受理成功');
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('11', 'aSuXCEfz', '2023-08-11 20:37:46', '2023-08-11 20:37:47', '20230811203746706aqf07cl33mty18', '003000TOP2B230811203747P042ac139d3100000', '6666000137506841', NULL, '1.00', NULL, NULL, '0', '2023-08-11 00:00:00', NULL, NULL, '02', '受理成功');
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('12', 'aSuXCEfz', '2023-08-11 20:40:38', '2023-08-11 20:40:39', '20230811204038570xnuqh9fw6xpswi', '003000TOP3A230811204038P913ac139d2100000', '6666000137506841', NULL, '1.00', NULL, NULL, '0', '2023-08-11 00:00:00', NULL, NULL, '02', '受理成功');
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('13', 'aSuXCEfz', '2023-08-11 20:52:31', '2023-08-11 20:52:31', '20230811205231207bqfqvpjey00f1q', '003000TOP1B230811205231P508ac139d2300000', '6666000137506841', NULL, '1.00', NULL, NULL, '0', '2023-08-11 00:00:00', NULL, NULL, '02', '受理成功');
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('14', 'aSuXCEfz', '2023-08-11 21:06:58', '2023-08-11 21:06:58', '202308112106584726vwuche3zbpw86', '003000TOP1A230811210658P793ac139fed00000', '6666000137506841', NULL, '0.10', NULL, NULL, '0', '2023-08-11 00:00:00', NULL, NULL, '02', '受理成功');
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('15', 'aSuXCEfz', '2023-08-12 14:13:37', '2023-08-12 14:13:37', '20230812141337390lkdjyeyrx7fikx', NULL, '6666000137506841', NULL, '0.01', NULL, NULL, '1', '2023-08-12 14:13:37', 'PT165169182081430151681', '0', '04', NULL);
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('16', 'aSuXCEfz', '2023-08-12 14:19:16', '2023-08-12 14:19:16', '20230812141916154td8n9uoybui7i5', NULL, '6666000137506841', NULL, '0.01', NULL, NULL, '1', '2023-08-12 14:19:16', 'PT733169182115211839356', '0', '04', NULL);
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('17', 'aSuXCEfz', '2023-08-12 14:20:42', '2023-08-12 14:20:42', '20230812142042303m9mdslcq7sk5c7', NULL, '6666000137506841', NULL, '0.01', NULL, NULL, '1', '2023-08-12 14:20:42', 'PT569169182123609949023', '0', '04', NULL);
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('18', 'aSuXCEfz', '2023-08-14 18:56:02', '2023-08-14 18:56:04', '20230814185604266i1kz02f2qax3ol', '003500TOP1B230814185604P605ac139c2c00000', '6666000137506841', '6666000137445326', '0.01', NULL, NULL, '1', '2023-08-14 18:56:04', 'PT580169201055792357039', '1', '03', NULL);
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('19', 'aSuXCEfz', '2023-08-14 18:56:47', '2023-08-14 18:56:48', '202308141856475345uhlrj23rwrqzr', '003500TOP1A230814185647P851ac139c3200000', '6666000137506841', '6666000137445326', '0.03', NULL, NULL, '1', '2023-08-14 18:56:48', 'PT889169201060410062894', '1', '03', NULL);
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('20', 'aSuXCEfz', '2023-08-14 19:53:13', '2023-08-14 19:53:12', '20230814195312707ydg3zzva0pzd2c', NULL, '6666000137506841', NULL, '0.01', NULL, NULL, '1', '2023-08-14 19:53:12', 'PT892169201399036312491', '0', '04', NULL);
INSERT INTO `eb_huifu_wallet_trade` (`id`, `uni_id`, `create_time`, `update_time`, `req_seq_id`, `hf_seq_id`, `expend_account_no`, `income_account_no`, `amount`, `good_desc`, `remark`, `trade_status`, `trans_finish_time`, `business_partner_seq`, `business_code`, `trade_type`, `error_msg`) VALUES ('21', 'aSuXCEfz', '2023-08-14 20:18:32', '2023-08-14 20:18:32', '20230814201832486qui88s96t1s4x2', NULL, '6666000137506841', NULL, '0.01', NULL, NULL, '1', '2023-08-14 20:18:32', 'PT813169201550989539284', '0', '04', NULL);


-- ----------------------------
-- Table structure for eb_huifu_wallet_translog
-- ----------------------------
-- DROP TABLE IF EXISTS `eb_huifu_wallet_translog`;
CREATE TABLE `eb_huifu_wallet_translog` (
                                            `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '账户提现记录主键ID',
                                            `uni_id` varchar(64) DEFAULT NULL COMMENT '用户uni_id',
                                            `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                            `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                            `trans_id` varchar(64) DEFAULT NULL COMMENT '出金交易流水编号',
                                            `trans_date` varchar(8) DEFAULT NULL COMMENT '交易请求日期',
                                            `card_no` varchar(64) DEFAULT NULL COMMENT '银行卡号(掩码)',
                                            `card_name` varchar(64) DEFAULT NULL COMMENT '银行户名',
                                            `bank_code` varchar(20) DEFAULT NULL COMMENT '银行编码',
                                            `trans_amt` varchar(20) DEFAULT NULL COMMENT '交易金额（元）',
                                            `fee_amt` varchar(20) DEFAULT NULL COMMENT '手续费（元）',
                                            `trans_type` varchar(20) DEFAULT NULL COMMENT '交易类型:SURROGATE-银行卡代发、ENCHASHMENT-取现',
                                            `remark` varchar(128) DEFAULT NULL COMMENT '备注',
                                            `trans_stat` varchar(2) DEFAULT NULL COMMENT '交易状态',
                                            `trans_desc` varchar(255) DEFAULT NULL COMMENT '交易描述',
                                            PRIMARY KEY (`id`) USING BTREE,
                                            KEY `index_com_wallet_translog_uni_id` (`uni_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='企业钱包账户提现记录';

INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('23', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP1A230811210658P793ac139fed00000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '0.10', '0.00', '取现', '', '成功', '交易成功');
INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('24', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP1B230811205231P508ac139d2300000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '1.00', '0.00', '取现', '', '成功', '交易成功');
INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('25', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP3A230811204038P913ac139d2100000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '1.00', '0.00', '取现', '', '成功', '交易成功');
INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('26', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP2B230811203747P042ac139d3100000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '1.00', '0.00', '取现', '', '成功', '交易成功');
INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('27', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP2B230811200820P444ac139c0b00000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '1.00', '0.00', '取现', '', '成功', '交易成功');
INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('28', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP3B230811200705P450ac139ffc00000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '1.00', '0.00', '取现', '', '成功', '交易成功');
INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('29', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP2B230811200545P282ac139d3100000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '1.00', '0.00', '取现', '', '成功', '交易成功');
INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('30', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP3A230811193157P388ac139d2100000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '1.00', '0.00', '取现', '', '成功', '交易成功');
INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('31', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP2A230811193131P515ac139c0800000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '1.00', '0.00', '取现', '', '成功', '交易成功');
INSERT INTO `eb_huifu_wallet_translog` (`id`, `uni_id`, `create_time`, `update_time`, `trans_id`, `trans_date`, `card_no`, `card_name`, `bank_code`, `trans_amt`, `fee_amt`, `trans_type`, `remark`, `trans_stat`, `trans_desc`) VALUES ('32', 'aSuXCEfz', '2023-08-15 13:45:10', '2023-08-15 13:45:10', '003000TOP2A230811154325P140ac139ced00000', '20230811', '3700020509245218394', '陕西众合保安服务有限公司', '1020000', '1.00', '0.00', '取现', '', '成功', '交易成功');

-- ----------------------------
-- Records of eb_system_config
-- ----------------------------
INSERT INTO `eb_system_config` (`id`, `name`, `title`, `form_id`, `value`, `status`, `create_time`, `update_time`, `form_name`) VALUES ('1268', 'front_pay_callback_url', 'front_pay_callback_url', '0', 'https://pay.mall.pre.baibaodun.cn', '0', '2023-02-20 09:52:13', '2023-07-24 14:55:48', '支付回调前端地址(域名)') ON DUPLICATE KEY UPDATE value = '''https://pay.mall.pre.baibaodun.cn''';


CREATE TABLE `temp_huifu_wallet_reconciliation` (
                                                    `trade_serial_no` varchar(64) NOT NULL COMMENT '交易流水号',
                                                    `create_time` datetime NOT NULL COMMENT '创建时间',
                                                    `merchant_no` varchar(64) DEFAULT NULL COMMENT '商户号',
                                                    `request_serial_no` varchar(64) DEFAULT NULL COMMENT '请求流水号',
                                                    `trade_date` varchar(10) DEFAULT NULL COMMENT '交易日期',
                                                    `trade_amount` varchar(20) DEFAULT NULL COMMENT '交易金额',
                                                    `trade_status` varchar(6) DEFAULT NULL COMMENT '交易状态',
                                                    `bank_trade_type` varchar(6) DEFAULT NULL COMMENT '银行交易类型',
                                                    `trade_start_time` varchar(20) DEFAULT NULL COMMENT '交易订单创建时间',
                                                    `trade_end_time` varchar(20) DEFAULT NULL COMMENT '交易订单完成时间',
                                                    `expend_account_no` varchar(30) DEFAULT NULL COMMENT '出账方账号',
                                                    `expend_account_name` varchar(100) DEFAULT NULL COMMENT '出账方户名',
                                                    `expend_bank_code` varchar(20) DEFAULT NULL COMMENT '出账方银行编码',
                                                    `income_account_no` varchar(32) DEFAULT NULL COMMENT '入账方账号',
                                                    `income_account_name` varchar(100) DEFAULT NULL COMMENT '入账方户名',
                                                    `incomed_bank_code` varchar(20) DEFAULT NULL COMMENT '入账方银行编码',
                                                    `income_cer_no` varchar(64) DEFAULT NULL COMMENT '入账方证件号',
                                                    `merchant_retain` varchar(128) DEFAULT NULL COMMENT '商户保留域',
                                                    `remark` varchar(255) DEFAULT NULL COMMENT '交易备注',
                                                    `service_charge` varchar(128) DEFAULT NULL COMMENT '手续费',
                                                    PRIMARY KEY (`trade_serial_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='企业钱包对账';

INSERT INTO `eb_schedule_job` (`job_id`, `bean_name`, `method_name`, `params`, `cron_expression`, `status`, `remark`, `is_delete`, `create_time`) VALUES ('25', 'WalletTradeTask', 'tradeDetail', NULL, '0 30 4 * * ?', '0', '每天4:30获取账务明细', '0', '2023-08-15 16:51:33');
INSERT INTO `eb_schedule_job` (`job_id`, `bean_name`, `method_name`, `params`, `cron_expression`, `status`, `remark`, `is_delete`, `create_time`) VALUES ('27', 'WalletTradeTask', 'reconciliationDetail', NULL, '0 15 4 * * ?', '0', '每天4:30定时获取对账单信息', '0', '2023-08-15 16:57:26');
INSERT INTO `eb_schedule_job` (`job_id`, `bean_name`, `method_name`, `params`, `cron_expression`, `status`, `remark`, `is_delete`, `create_time`) VALUES ('28', 'WalletTradeTask', 'translogDetail', NULL, '0 0 */1 * * ?', '0', '每小时获取提现记录', '0', '2023-08-15 17:02:11');

