/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemMenu;
import com.zbkj.common.model.admin.SystemRoleMenu;
import com.zbkj.common.request.SystemMenuRequest;
import com.zbkj.common.request.SystemMenuSearchRequest;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.MenuCheckTree;
import com.zbkj.common.vo.MenuCheckVo;
import com.zbkj.service.dao.SystemMenuDao;
import com.zbkj.service.service.SystemMenuService;
import com.zbkj.service.service.SystemRoleMenuService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class SystemMenuServiceImpl
extends ServiceImpl<SystemMenuDao, SystemMenu>
implements SystemMenuService {
    @Resource
    private SystemMenuDao dao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SystemRoleMenuService roleMenuService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public List<SystemMenu> getAllPermissions(Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemMenu::getIsDelte, (Object)false);
        lqw.eq(SystemMenu::getType, (Object)type);
        lqw.ne(SystemMenu::getMenuType, (Object)"M");
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<SystemMenu> findPermissionByUserId(Integer userId) {
        return this.dao.findPermissionByUserId(userId);
    }

    @Override
    public List<SystemMenu> findAllCatalogue(Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemMenu::getIsDelte, (Object)false);
        lqw.eq(SystemMenu::getIsShow, (Object)true);
        lqw.eq(SystemMenu::getType, (Object)type);
        lqw.ne(SystemMenu::getMenuType, (Object)"A");
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<SystemMenu> getMenusByUserId(Integer userId) {
        return this.dao.getMenusByUserId(userId);
    }

    @Override
    public List<MenuCheckVo> getMenuCacheList() {
        List<SystemMenu> menuList = this.getCacheList(RoleEnum.MERCHANT_ADMIN.getValue());
        List voList = menuList.stream().map(e -> {
            MenuCheckVo menuCheckVo = new MenuCheckVo();
            BeanUtils.copyProperties((Object)e, (Object)menuCheckVo);
            return menuCheckVo;
        }).collect(Collectors.toList());
        MenuCheckTree menuTree = new MenuCheckTree(voList);
        return menuTree.buildTree();
    }

    @Override
    public List<SystemMenu> getMenuCacheList(Integer type) {
        return this.getCacheList(type);
    }

    @Override
    public List<SystemMenu> getPlatformList(SystemMenuSearchRequest request) {
        return this.getAdminList(request, RoleEnum.PLATFORM_ADMIN.getValue());
    }

    @Override
    public List<SystemMenu> getMerchantList(SystemMenuSearchRequest request) {
        return this.getAdminList(request, RoleEnum.MERCHANT_ADMIN.getValue());
    }

    @Override
    public Boolean addPlatformMenu(SystemMenuRequest systemMenuRequest) {
        return this.add(systemMenuRequest, RoleEnum.PLATFORM_ADMIN.getValue());
    }

    @Override
    public Boolean addMerchantMenu(SystemMenuRequest systemMenuRequest) {
        return this.add(systemMenuRequest, RoleEnum.MERCHANT_ADMIN.getValue());
    }

    private Boolean add(SystemMenuRequest request, Integer type) {
        if (request.getMenuType().equals("C") && StrUtil.isEmpty((CharSequence)request.getComponent())) {
            throw new CrmebException("\u83dc\u5355\u7c7b\u578b\u7684\u7ec4\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getMenuType().equals("A") && StrUtil.isEmpty((CharSequence)request.getPerms())) {
            throw new CrmebException("\u6309\u94ae\u7c7b\u578b\u7684\u6743\u9650\u8868\u793a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SystemMenu systemMenu = new SystemMenu();
        request.setId(null);
        BeanUtils.copyProperties((Object)request, (Object)systemMenu);
        systemMenu.setType(type);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.save(systemMenu);
            SystemRoleMenu systemRoleMenu = new SystemRoleMenu();
            systemRoleMenu.setMenuId(systemMenu.getId());
            if (type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
                systemRoleMenu.setRid(Integer.valueOf(1));
            }
            if (type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
                systemRoleMenu.setRid(Integer.valueOf(2));
            }
            this.roleMenuService.save(systemRoleMenu);
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            if (type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
                this.redisUtil.delete(new String[]{"platformMenuList"});
            }
            if (type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
                this.redisUtil.delete(new String[]{"merchantMenuList"});
            }
        }
        return execute;
    }

    @Override
    public Boolean deletePlatformMenu(Integer id) {
        return this.deleteById(id, RoleEnum.PLATFORM_ADMIN.getValue());
    }

    @Override
    public Boolean deleteMerchantMenu(Integer id) {
        return this.deleteById(id, RoleEnum.MERCHANT_ADMIN.getValue());
    }

    @Override
    public Boolean editPlatformMenu(SystemMenuRequest systemMenuRequest) {
        return this.edit(systemMenuRequest, RoleEnum.PLATFORM_ADMIN.getValue());
    }

    @Override
    public Boolean editMerchantMenu(SystemMenuRequest systemMenuRequest) {
        return this.edit(systemMenuRequest, RoleEnum.MERCHANT_ADMIN.getValue());
    }

    @Override
    public SystemMenu getInfo(Integer id) {
        SystemMenu systemMenu = this.getInfoById(id);
        systemMenu.setCreateTime(null);
        return systemMenu;
    }

    @Override
    public Boolean updatePlatformShowStatus(Integer id) {
        return this.updateShowStatus(id, RoleEnum.PLATFORM_ADMIN.getValue());
    }

    @Override
    public Boolean updateMerchantShowStatus(Integer id) {
        return this.updateShowStatus(id, RoleEnum.MERCHANT_ADMIN.getValue());
    }

    @Override
    public List<MenuCheckVo> getPlatformMenuCacheTree() {
        List<SystemMenu> menuList = this.getCacheList(RoleEnum.PLATFORM_ADMIN.getValue());
        List voList = menuList.stream().map(e -> {
            MenuCheckVo menuCheckVo = new MenuCheckVo();
            BeanUtils.copyProperties((Object)e, (Object)menuCheckVo);
            return menuCheckVo;
        }).collect(Collectors.toList());
        MenuCheckTree menuTree = new MenuCheckTree(voList);
        return menuTree.buildTree();
    }

    private Boolean updateShowStatus(Integer id, Integer type) {
        SystemMenu systemMenu = this.getInfoById(id);
        if (!systemMenu.getType().equals(type)) {
            throw new CrmebException("\u7cfb\u7edf\u83dc\u5355\u4e0d\u5b58\u5728");
        }
        systemMenu.setIsShow(Boolean.valueOf(systemMenu.getIsShow() == false));
        boolean update = this.updateById(systemMenu);
        if (update) {
            if (type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
                this.redisUtil.delete(new String[]{"platformMenuList"});
            }
            if (type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
                this.redisUtil.delete(new String[]{"merchantMenuList"});
            }
        }
        return update;
    }

    private Boolean edit(SystemMenuRequest request, Integer type) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException("\u7cfb\u7edf\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getMenuType().equals("C") && StrUtil.isEmpty((CharSequence)request.getComponent())) {
            throw new CrmebException("\u83dc\u5355\u7c7b\u578b\u7684\u7ec4\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getMenuType().equals("A") && StrUtil.isEmpty((CharSequence)request.getPerms())) {
            throw new CrmebException("\u6309\u94ae\u7c7b\u578b\u7684\u6743\u9650\u8868\u793a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SystemMenu oldMenu = this.getInfoById(request.getId());
        if (!oldMenu.getType().equals(type)) {
            throw new CrmebException("\u7cfb\u7edf\u83dc\u5355\u4e0d\u5b58\u5728");
        }
        SystemMenu systemMenu = new SystemMenu();
        BeanUtils.copyProperties((Object)request, (Object)systemMenu);
        boolean update = this.updateById(systemMenu);
        if (update) {
            if (type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
                this.redisUtil.delete(new String[]{"platformMenuList"});
            }
            if (type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
                this.redisUtil.delete(new String[]{"merchantMenuList"});
            }
        }
        return update;
    }

    private SystemMenu getInfoById(Integer id) {
        SystemMenu systemMenu = (SystemMenu)this.getById(id);
        if (ObjectUtil.isNull((Object)systemMenu) || systemMenu.getIsDelte().booleanValue()) {
            throw new CrmebException("\u7cfb\u7edf\u83dc\u5355\u4e0d\u5b58\u5728");
        }
        return systemMenu;
    }

    private Boolean deleteById(Integer id, Integer type) {
        String redisKey;
        SystemMenu systemMenu = this.getInfoById(id);
        if (!systemMenu.getType().equals(type)) {
            throw new CrmebException("\u7cfb\u7edf\u83dc\u5355\u4e0d\u5b58\u5728");
        }
        systemMenu.setIsDelte(Boolean.valueOf(true));
        String string = redisKey = type.equals(RoleEnum.PLATFORM_ADMIN.getValue()) ? "platformMenuList" : "merchantMenuList";
        if (systemMenu.getMenuType().equals("A")) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(systemMenu);
                if (type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
                    this.roleMenuService.deleteByRidAndMenuId(1, systemMenu.getId());
                }
                if (type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
                    this.roleMenuService.deleteByRidAndMenuId(2, systemMenu.getId());
                }
                return Boolean.TRUE;
            });
            if (execute.booleanValue()) {
                this.redisUtil.delete(new String[]{redisKey});
            }
            return execute;
        }
        List<SystemMenu> childList = this.findAllChildListByPid(id, systemMenu.getMenuType());
        if (CollUtil.isEmpty(childList)) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(systemMenu);
                if (type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
                    this.roleMenuService.deleteByRidAndMenuId(1, systemMenu.getId());
                }
                if (type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
                    this.roleMenuService.deleteByRidAndMenuId(2, systemMenu.getId());
                }
                return Boolean.TRUE;
            });
            if (execute.booleanValue()) {
                this.redisUtil.delete(new String[]{redisKey});
            }
            return execute;
        }
        childList.forEach(e -> e.setIsDelte(Boolean.valueOf(true)));
        childList.add(systemMenu);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateBatchById(childList);
            List<Integer> menuIdList = childList.stream().map(SystemMenu::getId).collect(Collectors.toList());
            if (type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
                this.roleMenuService.deleteByRidAndMenuIdList(1, menuIdList);
            }
            if (type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
                this.roleMenuService.deleteByRidAndMenuIdList(2, menuIdList);
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.redisUtil.delete(new String[]{redisKey});
        }
        return execute;
    }

    private List<SystemMenu> findAllChildListByPid(Integer pid, String menuType) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemMenu::getPid, (Object)pid);
        lqw.eq(SystemMenu::getIsDelte, (Object)false);
        if (menuType.equals("C")) {
            return this.dao.selectList((Wrapper)lqw);
        }
        List menuList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)menuList)) {
            return menuList;
        }
        List pidList = menuList.stream().map(SystemMenu::getId).collect(Collectors.toList());
        lqw.clear();
        lqw.in(SystemMenu::getPid, pidList);
        lqw.eq(SystemMenu::getIsDelte, (Object)false);
        List childMenuList = this.dao.selectList((Wrapper)lqw);
        menuList.addAll(childMenuList);
        return menuList;
    }

    private List<SystemMenu> getAdminList(SystemMenuSearchRequest request, Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            String decode = URLUtil.decode((String)request.getName());
            lqw.like(SystemMenu::getName, (Object)decode);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getMenuType())) {
            lqw.eq(SystemMenu::getMenuType, (Object)request.getMenuType());
        }
        lqw.eq(SystemMenu::getIsDelte, (Object)false);
        lqw.eq(SystemMenu::getType, (Object)type);
        lqw.orderByDesc(SystemMenu::getSort);
        lqw.orderByAsc(SystemMenu::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    private List<SystemMenu> getCacheList(Integer type) {
        String redisKey;
        String string = redisKey = type.equals(RoleEnum.PLATFORM_ADMIN.getValue()) ? "platformMenuList" : "merchantMenuList";
        if (this.redisUtil.exists(redisKey).booleanValue()) {
            return (List)this.redisUtil.get(redisKey);
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemMenu::getIsDelte, (Object)false);
        lqw.eq(SystemMenu::getType, (Object)type);
        List systemMenuList = this.dao.selectList((Wrapper)lqw);
        this.redisUtil.set(redisKey, (Object)systemMenuList);
        return systemMenuList;
    }
}

