/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.QRCodeUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.vo.QrCodeVo;
import com.zbkj.service.service.QrCodeService;
import com.zbkj.service.service.WechatService;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QrCodeServiceImpl
implements QrCodeService {
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private WechatService wechatService;

    @Override
    public QrCodeVo getWecahtQrCode(JSONObject data) {
        if (ObjectUtil.isNull((Object)data) || data.isEmpty()) {
            throw new CrmebException("\u751f\u6210\u5fae\u4fe1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QrCodeVo vo = new QrCodeVo();
        vo.setCode(this.wechatService.createQrCode(data));
        return vo;
    }

    @Override
    public QrCodeVo urlToBase64(String url) {
        byte[] bytes = this.restTemplateUtil.getBuffer(url);
        String base64Image = CrmebUtil.getBase64Image((String)Base64.encodeBase64String((byte[])bytes));
        QrCodeVo vo = new QrCodeVo();
        vo.setCode(base64Image);
        return vo;
    }

    @Override
    public QrCodeVo strToBase64(String text, Integer width, Integer height) {
        String base64Image;
        if (!(width >= 50 && height >= 50 || width <= 500 && height <= 500 || text.length() < 999)) {
            throw new CrmebException("\u751f\u6210\u4e8c\u7ef4\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        try {
            base64Image = QRCodeUtil.crateQRCode((String)text, (int)width, (int)height);
        }
        catch (Exception e) {
            throw new CrmebException("\u751f\u6210\u4e8c\u7ef4\u7801\u5f02\u5e38");
        }
        QrCodeVo vo = new QrCodeVo();
        vo.setCode(base64Image);
        return vo;
    }
}

