/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.api.internal.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;

public class MybankLogger {
    private static final Log clog = LogFactory.getLog((String)"server.comm.error");
    private static final Log blog = LogFactory.getLog((String)"server.biz.error");
    private static final Log blogDebug = LogFactory.getLog((String)"server.biz.debug");
    private static String osName = System.getProperties().getProperty("os.name");
    private static String ip;
    private static boolean needEnableLogger;

    public static void setNeedEnableLogger(boolean needEnableLogger) {
        MybankLogger.needEnableLogger = needEnableLogger;
    }

    public static void setIp(String ip) {
        MybankLogger.ip = ip;
    }

    public static Boolean isBizDebugEnabled() {
        return blog.isDebugEnabled();
    }

    public static void logBizError(Throwable t) {
        if (!needEnableLogger) {
            return;
        }
        blog.error((Object)t);
    }

    public static void logCommError(Exception e, String serverUrl, String xmlContent, String apiFunction, String apiVersion) {
        if (!needEnableLogger) {
            return;
        }
        MybankLogger.logCommErrorHandle(e, null, serverUrl, xmlContent, apiFunction, apiVersion);
    }

    public static void logCommError(Exception e, HttpURLConnection conn, String xmlContent, String apiFunction, String apiVersion) {
        if (!needEnableLogger) {
            return;
        }
        MybankLogger.logCommErrorHandle(e, conn, null, xmlContent, apiFunction, apiVersion);
    }

    private static void logCommErrorHandle(Exception e, HttpURLConnection conn, String serverUrl, String xmlContent, String apiFunction, String apiVersion) {
        String urlStr = null;
        String rspCode = "";
        if (conn != null) {
            try {
                urlStr = conn.getURL().toString();
                rspCode = "HTTP_ERROR_" + conn.getResponseCode();
            }
            catch (IOException iOException) {}
        } else {
            urlStr = serverUrl;
            rspCode = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")));
        sb.append("^_^");
        sb.append(apiFunction);
        sb.append("^_^");
        sb.append(apiVersion);
        sb.append("^_^");
        sb.append(ip);
        sb.append("^_^");
        sb.append(osName);
        sb.append("^_^");
        sb.append(urlStr);
        sb.append("^_^");
        sb.append(xmlContent);
        sb.append("^_^");
        sb.append(rspCode);
        sb.append("^_^");
        sb.append((e.getMessage() + "").replaceAll("\r\n", " "));
        clog.error((Object)sb.toString());
    }

    public static void logCommError(Exception e, HttpResponse response, String serverUrl, String entityString, String apiFunction, String apiVersion) {
        String rspCode = response != null ? "HTTP_ERROR_" + response.getStatusLine().getStatusCode() : "";
        StringBuilder sb = new StringBuilder();
        sb.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")));
        sb.append("^_^");
        sb.append(apiFunction);
        sb.append("^_^");
        sb.append(apiVersion);
        sb.append("^_^");
        sb.append(ip);
        sb.append("^_^");
        sb.append(osName);
        sb.append("^_^");
        sb.append(serverUrl);
        sb.append("^_^");
        sb.append(entityString);
        sb.append("^_^");
        sb.append(rspCode);
        sb.append("^_^");
        sb.append((e.getMessage() + "").replaceAll("\r\n", " "));
        clog.error((Object)sb.toString());
    }

    public static void logBizError(String rspContent, Map<String, Long> costTimeMap) {
        if (!needEnableLogger) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")));
        sb.append("^_^");
        sb.append(rspContent);
        sb.append("^_^");
        sb.append(costTimeMap.get("prepareCostTime"));
        sb.append("ms,");
        sb.append(costTimeMap.get("requestCostTime"));
        sb.append("ms,");
        sb.append(costTimeMap.get("postCostTime"));
        sb.append("ms");
        blog.error((Object)sb.toString());
    }

    public static void logBizSummary(Map<String, Object> rt, Map<String, Long> costTimeMap) {
        if (!needEnableLogger) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Summary");
        sb.append("^_^");
        sb.append("\u5ba2\u6237\u7aef\u53d1\u9001\u62a5\u6587:");
        sb.append((String)rt.get("requestContent"));
        sb.append("^_^");
        sb.append("\t\n");
        sb.append("\u5ba2\u6237\u7aef\u63a5\u6536\u62a5\u6587:");
        sb.append((String)rt.get("rspContent"));
        sb.append("^_^");
        sb.append(costTimeMap.get("prepareCostTime"));
        sb.append("ms,");
        sb.append(costTimeMap.get("requestCostTime"));
        sb.append("ms,");
        sb.append(costTimeMap.get("postCostTime"));
        sb.append("ms");
        blogDebug.debug((Object)sb.toString());
    }

    static {
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        needEnableLogger = true;
    }
}

