/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.payment.tasks;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.zbkj.payment.entities.PaymentTransactionEntity;
import com.zbkj.payment.mappers.PaymentTransactionMapper;
import com.zbkj.service.payments.WalletPaymentService;
import com.zbkj.service.payments.commands.ReplenishOrderPlatformFeeCommand;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ReplenishOrderPlatformFeeTask")
public class ReplenishOrderPlatformFeeTask {
    private static final Logger logger = LoggerFactory.getLogger(ReplenishOrderPlatformFeeTask.class);
    private final WalletPaymentService paymentService;
    private final PaymentTransactionMapper paymentTransactionMapper;

    public ReplenishOrderPlatformFeeTask(WalletPaymentService paymentService, PaymentTransactionMapper paymentTransactionMapper) {
        this.paymentService = paymentService;
        this.paymentTransactionMapper = paymentTransactionMapper;
    }

    public void execute() {
        logger.error("---ReplenishOrderPlatformFeeTask task------auto replenish order platform fee");
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(PaymentTransactionEntity::getStatus, (Object)PaymentTransactionEntity.TransactionStatus.PENDING.ordinal());
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(PaymentTransactionEntity::getTransactionType, (Object)PaymentTransactionEntity.TransactionType.OrderPlatformFee.ordinal());
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 3);
        Date expiredTime = calendar.getTime();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.le(PaymentTransactionEntity::getCreateTime, (Object)expiredTime);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(" limit 20");
        lambdaQueryWrapper = lambdaQueryWrapper.select(new SFunction[]{PaymentTransactionEntity::getReqSeqId});
        List transactionMaps = this.paymentTransactionMapper.selectMaps((Wrapper)lambdaQueryWrapper);
        logger.error("\u8865\u5145\u8ba2\u5355\u5e73\u53f0\u8d39\u7528\u4efb\u52a1: \u6570\u91cf={}", (Object)transactionMaps.size());
        try {
            Collection rplIds = transactionMaps.stream().map(ii -> String.valueOf(ii.get("reqSeqId"))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)rplIds)) {
                this.paymentService.dispatch(ReplenishOrderPlatformFeeCommand.create((Collection)rplIds));
            }
        }
        catch (Exception e) {
            logger.error("ReplenishOrderPlatformFeeTask.execute \u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }
}

