package com.bcxin.wps.entity;

import cn.wps.solution.weboffice.provider.v3.model.FileInfo;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

@Data
@Builder
@AllArgsConstructor
@TableName("wps_files")
public class File {
    private String id;

    private int version;

    private String name;

    private String url;

    private long size;

    private String env;

    /**
     * 原来的url是否经过了加密操作
     */
    private boolean encrypted;

    private Timestamp createTime;

    private Timestamp modifyTime;

    private String creatorId;

    private String modifierId;

    private String permissionOption;

    public File() {
        this.setCreateTime(Timestamp.from(Instant.now()));
    }

    public FileInfo toFileInfo() {
        Timestamp changedTime  = this.modifyTime==null?this.createTime:this.modifyTime;
        return FileInfo.builder()
                .id(this.getId())
                .name(this.name)
                .version(this.getVersion())
                .size(this.size)
                .createTime(LocalDateTime.ofInstant(this.createTime.toInstant(), ZoneId.systemDefault()))
                .modifyTime(LocalDateTime.ofInstant(changedTime.toInstant(), ZoneId.systemDefault()))
                .creatorId(this.getCreatorId())
                .modifierId(this.getModifierId())
                .build();
    }

    public File copyForNew(String userId,String name,int newVersion) {
        File f = this;
        File newFile =
                File.builder()
                        .id(f.getId())
                        .url(f.getUrl())
                        .creatorId(f.getCreatorId())
                        .encrypted(f.isEncrypted())
                        .permissionOption(f.getPermissionOption())
                        .modifierId(userId)
                        .createTime(f.getCreateTime())
                        .modifyTime(Timestamp.from(Instant.now()))
                        .env(f.getEnv())
                        .encrypted(f.isEncrypted())
                        .version(newVersion)
                        .name(name)
                        .build();

        return newFile;
    }
}
