package com.bcxin.service.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.bcxin.config.WPSConfig;
import com.bcxin.model.domain.Xfile;
import com.bcxin.service.IWpsFilePreview;
import com.bcxin.utils.ResultUtil;
import com.bcxin.utils.constant.Const;
import com.bcxin.utils.constant.ResultEnum;
import com.bcxin.utils.wps.WPSUtils;
import com.bcxin.vo.wps.ResultVo;
import com.google.common.io.Files;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author jianjun.wang
 * @version V1.0
 * @className WpsFilePreviewImpl
 * @packageName com.bcxin.service.impl
 * @description 文件预览实现类
 * @data 2019-09-02 13:54
 **/
@Service
@Slf4j
public class WpsFilePreviewImpl implements IWpsFilePreview {

    @Resource
    private com.bcxin.dao.XfileMapper XfileMapper;

    /**
     * 转wps预览服务
     * 保证同时只有一个线程访问
     */
    @Override
    public synchronized ResultVo previewHandle(@NonNull String fileUrl, @NonNull String readonly,String envi) throws Exception {
        /* 查询是否曾经生成过 */
        List<Xfile> xfileList = XfileMapper.selectByFileUrl(fileUrl);
        Xfile xfile;
        if (CollUtil.isEmpty(xfileList)) {
            xfile = new Xfile();
            xfile.setCreateOn(DateUtil.date());
            xfile.setFileUrl(fileUrl);
            xfile.setOid(IdWorker.getId());
            XfileMapper.insert(xfile);
        } else {
            xfile = xfileList.get(0);
        }
        //连接wps开放平台的fileId，是sysName+fileId
        /**拼接字符串**/
        //获得后缀
        String fileType = Files.getFileExtension(fileUrl);
        //获得文件类型缩写
        String type = "";
        //文件预览支持格式和文件编辑支持格式不一样
        if (StringUtils.equals(readonly, Const.Y)) {//读
            //判断的时候忽略大小写
            if (StrUtil.containsIgnoreCase(WPSConfig.WPS_PREVIEW_TYPE_EXCEL, fileType)) {
                type = "s";
            } else if (StrUtil.containsIgnoreCase(WPSConfig.WPS_PREVIEW_TYPE_WORD, fileType)) {
                type = "w";
            } else if (StrUtil.containsIgnoreCase(WPSConfig.WPS_PREVIEW_TYPE_PPT, fileType)) {
                type = "p";
            } else if (StrUtil.containsIgnoreCase("pdf", fileType)) {
                type = "f";
            } else {
                log.error("wps预览接口调用失败，文件格式不支持");
                ResultUtil.error(ResultEnum.FAIL.getCode(), "文件格式不支持");
            }
        } else {
            //判断的时候忽略大小写
            if (StrUtil.containsIgnoreCase(WPSConfig.WPS_EDIT_TYPE_EXCEL, fileType)) {
                type = "s";
            } else if (StrUtil.containsIgnoreCase(WPSConfig.WPS_EDIT_TYPE_WORD, fileType)) {
                type = "w";
            } else if (StrUtil.containsIgnoreCase(WPSConfig.WPS_EDIT_TYPE_PPT, fileType)) {
                type = "p";
            } else if (StrUtil.containsIgnoreCase("pdf", fileType)) {
                type = "f";
            } else {
                log.error("wps编辑接口调用失败，文件格式不支持");
                ResultUtil.error(ResultEnum.FAIL.getCode(), "文件格式不支持");
            }
        }
        String previewUrl = WPSUtils.generateOnlineUrl(type, xfile.getOid().toString(), Base64.encode(fileUrl), readonly,envi);
        return ResultUtil.success(previewUrl);
    }

//    @Override
//    public ResultVo editService(String filePath, String fileId, String version) throws Exception {
//        return null;
//    }

}
