/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.framework.shiro.session;

import com.bcxin.auth.common.utils.IpUtils;
import com.bcxin.auth.common.utils.ServletUtils;
import com.bcxin.auth.framework.shiro.session.OnlineSession;
import eu.bitwalker.useragentutils.UserAgent;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionFactory;
import org.apache.shiro.web.session.mgt.WebSessionContext;
import org.springframework.stereotype.Component;

@Component
public class OnlineSessionFactory
implements SessionFactory {
    public Session createSession(SessionContext initData) {
        WebSessionContext sessionContext;
        HttpServletRequest request;
        OnlineSession session = new OnlineSession();
        if (initData != null && initData instanceof WebSessionContext && (request = (HttpServletRequest)(sessionContext = (WebSessionContext)initData).getServletRequest()) != null) {
            UserAgent userAgent = UserAgent.parseUserAgentString((String)ServletUtils.getRequest().getHeader("User-Agent"));
            String os = userAgent.getOperatingSystem().getName();
            String browser = userAgent.getBrowser().getName();
            session.setHost(IpUtils.getIpAddr((HttpServletRequest)request));
            session.setBrowser(browser);
            session.setOs(os);
        }
        return session;
    }
}

