/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.framework.config.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"com.bcxin.zw.mapper"}, sqlSessionFactoryRef="zwSqlSessionFactory")
public class FingerprintDSConfig {
    private final String mapperLocation = "classpath:mapper/zw/*.xml";

    @Bean(name={"zwDataSource"})
    @ConfigurationProperties(prefix="zw.datasource")
    public DataSource zwDataSource() {
        return new DruidDataSource();
    }

    @Bean(name={"zwSqlSessionFactory"})
    @ConditionalOnBean(name={"zwDataSource"})
    public SqlSessionFactory zwSqlSessionFactory(@Qualifier(value="zwDataSource") DataSource zwDataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(zwDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/zw/*.xml"));
        return sessionFactory.getObject();
    }
}

