/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class ImageProcessEnding {
    private static final Logger logger = LoggerFactory.getLogger(ImageProcessEnding.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImgUrlToByte(String imgUrl) {
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        byte[] buffer = null;
        try {
            URL url = new URL(imgUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            inputStream = conn.getInputStream();
            outputStream = new ByteArrayOutputStream();
            buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
            buffer = outputStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return buffer;
    }

    public static byte[] compressImage(byte[] imageByte, int ppi) {
        byte[] smallImage = null;
        int width = 0;
        int height = 0;
        if (imageByte == null) {
            logger.error("compressImage\uff08\uff09==\u300b \u7f51\u7edc\u56fe\u7247\u8d44\u6e90\u63d0\u53d6\u5931\u8d25");
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageByte);
        try {
            BufferedImage image = ImageIO.read(byteArrayInputStream);
            int w = ((Image)image).getWidth(null);
            int h = ((Image)image).getHeight(null);
            double scale = 0.0;
            scale = Math.min((float)ppi / (float)w, (float)ppi / (float)h);
            width = (int)((double)w * scale);
            width -= width % 4;
            height = (int)((double)h * scale);
            if (scale >= 1.0) {
                return imageByte;
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            bufferedImage.getGraphics().drawImage(image.getScaledInstance(width, height, 4), 0, 0, null);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", out);
            smallImage = out.toByteArray();
            return smallImage;
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u56fe\u7247\u538b\u7f29\u5931\u8d25");
            return null;
        }
    }

    public static String ImageByteToBaseCode(byte[] data) {
        String encode = null;
        BASE64Encoder encoder = new BASE64Encoder();
        encode = encoder.encode(data);
        return encode;
    }
}

