package com.bcxin.obpm.schedule;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.utils.DES3;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.system.domain.FileRecord;
import com.bcxin.auth.system.domain.SysConfig;
import com.bcxin.auth.system.mapper.FileRecordMapper;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.service.ITenantUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/**
 * @Auther linqinglin
 * @date 2021/4/28 21:49
 */
@Component("dataSyncTask")
public class DataSyncTask {

    private static Logger logger = LoggerFactory.getLogger(DataSyncTask.class);

    @Autowired
    ISysConfigService configService;

    @Autowired
    ConfigUtil configUtil;

    @Autowired
    ITenantUserService tenantUserService;

    @Autowired
    FileRecordMapper fileRecordMapper;

    private boolean lock = false;

    public void run(){
        if(lock){
            return;
        }
        lock = true;

        try {
            if(!configUtil.isIntranet()){
                String dataSyncDate = configService.selectConfigByKey(Constants.DATASYNC_DATE);
                if(StrUtil.isEmpty(dataSyncDate)){
                    dataSyncDate = DateUtils.getYesterday();
                }
                Date startDate = DateUtils.dateTime(DateUtils.YYYY_MM_DD,dataSyncDate);
                Date endDate = DateUtils.dateTime(DateUtils.YYYY_MM_DD,DateUtils.getYesterday());
                if(startDate.getTime() > endDate.getTime()){
                    dataSyncDate = DateUtils.getYesterday();
                }

                List<Date> dateList = DateUtils.getBetweenDates(dataSyncDate, DateUtils.getTomorrow());

                for (Date date : dateList) {
                    try {
                        String dirFilePath = BMSConfig.getDataSyncProfile()+ DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,date);
                        File dirFile = new File(dirFilePath);
                        if (!dirFile.getParentFile().exists()) {
                            dirFile.getParentFile().mkdirs();
                            continue;
                        }

                        if (!dirFile.exists()) {
                            continue;
                        }
                        File[] files = dirFile.listFiles();
                        List<String> filePaths = new ArrayList<String>();
                        for (int i = 0; i < files.length; i++) {
                            File zipFile = files[i];
                            if(zipFile.getName().endsWith(Constants.ZIP)){
                                //输入源zip路径
                                ZipInputStream Zin = new ZipInputStream(new FileInputStream(zipFile));
                                BufferedInputStream Bin = new BufferedInputStream(Zin);

                                FileRecord fileRecord = fileRecordMapper.findByFileName(zipFile.getName());
                                if(fileRecord == null){
                                    //输出路径（文件夹目录）
                                    String resultFilePath = BMSConfig.getTempPath() + File.separatorChar + DateUtils.getDate() + File.separatorChar;
                                    File localFile = null;
                                    ZipEntry entry;
                                    try {
                                        while ((entry = Zin.getNextEntry()) != null && !entry.isDirectory()) {
                                            localFile = new File(resultFilePath, entry.getName());
                                            if (!localFile.exists()) {
                                                (new File(localFile.getParent())).mkdirs();
                                            }
                                            FileOutputStream out = new FileOutputStream(localFile);
                                            BufferedOutputStream Bout = new BufferedOutputStream(out);
                                            int b;
                                            while ((b = Bin.read()) != -1) {
                                                Bout.write(b);
                                            }
                                            Bout.close();
                                            out.close();
                                            if (localFile.getName().endsWith(".data")) {
                                                try {
                                                    BufferedReader br = new BufferedReader(new FileReader(localFile));
                                                    StringBuffer content = new StringBuffer();
                                                    // 获取文件内容
                                                    String lineTxt = null;
                                                    while ((lineTxt = br.readLine()) != null) {
                                                        // 使用readLine方法，一次读一行
                                                        content.append(lineTxt);
                                                    }
                                                    br.close();
                                                    //文件内容解密
                                                    String jsonStr = DES3.decode(content.toString());
                                                    TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
                                                    //jsonStr = JSON.toJSONStringWithDateFormat(jsonStr, DateUtils.YYYY_MM_DD_HH_MM_SS, SerializerFeature.WriteMapNullValue);
                                                    List<AuthLog> list = JSONArray.parseArray(jsonStr, AuthLog.class);
                                                    tenantUserService.updateBatchAuthStatusToCom(list);
                                                } catch (Exception e) {
                                                    e.printStackTrace();
                                                    logger.error("读取同步文件失败：{}",e);
                                                }

                                            }
                                            filePaths.add(localFile.getPath());
                                            logger.info(localFile + "解压成功");
                                        }
                                        Bin.close();
                                        Zin.close();
                                    } catch (IOException e) {
                                        logger.error(e.getMessage());
                                        throw e;
                                    }
                                    fileRecord = new FileRecord();
                                    fileRecord.setFileName(zipFile.getName());
                                    fileRecord.setFilePath(zipFile.getAbsolutePath());
                                    fileRecord.setCreateTime(new Date());
                                    fileRecord.setUpdateTime(new Date());

                                    fileRecordMapper.save(fileRecord);
                                }
                            }
                        }
                        for (String filePath : filePaths) {
                            FileUtil.del(filePath);
                        }
                        SysConfig config = new SysConfig();
                        config.setConfigKey("DATASYNC_DATE");
                        config.setConfigValue(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,date));
                        configService.updateConfigByKey(config);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
        }finally {
            lock = false;
        }
    }

}
