package com.bcxin.obpm.dto.Ministerial;


import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 保安服务公司主要管理人员信息上报实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "tlk_ManagementLayer", extraWhere = "and t1.ITEM_DOMAIN_ID in (select tlk_companyinformation.ITEM_DOMAIN_ID from tlk_companyinformation where item_officeType in ('0102','保安服务公司') and ITEM_isSub='1')")
public class Bafwgsglry extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "(select item_companyCode from tlk_companyinformation where tlk_companyinformation.item_domain_id = t1.item_domain_id limit 1)", isSubQuery = true)
    private String bagsbm;
    /**
     * 身份证号
     */
    @MinisterialAttr(column = "ITEM_documentID")
    private String sfzh;
    /**
     * 姓名
     */
    @MinisterialAttr(column = "ITEM_name")
    private String xm;
    /**
     * 性别
     */
    @MinisterialAttr(column = "ITEM_documentID", DATA_FORMAT = MinisterialDataFormat.GENDER)
    private String xb;
    /**
     * 民族
     */
    @MinisterialAttr(column = "ITEM_nation")
    private String mz;
    /**
     * 出生日期
     */
    @MinisterialAttr(column = "ITEM_documentID",DATA_FORMAT = MinisterialDataFormat.BIRTH)
    private String csrq;
    /**
     * 国籍
     */
    private String gj;
    /**
     * 职务
     */
    @MinisterialAttr(column = "ITEM_jobType", DATA_FORMAT = MinisterialDataFormat.JOB_LEVEL)
    private String zw;
    /**
     * 职业技能等级
     */
    @MinisterialAttr(column = "ITEM_skillLevel", DATA_FORMAT = MinisterialDataFormat.JOB_LEVEL)
    private String baydj;
    /**
     * 联系电话
     */
    @MinisterialAttr(column = "ITEM_phone")
    private String lxdh;
    /**
     * 证件类型
     */
    @MinisterialAttr(column = "ITEM_documentType", DATA_FORMAT = MinisterialDataFormat.MANAGER_CARD_TYPE)
    private String gatlx;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;


    @Override
    public String toString() {
        return "Bafwgsglry{" +
                "bagsbm='" + bagsbm + '\'' +
                ", sfzh='" + sfzh + '\'' +
                ", xm='" + xm + '\'' +
                ", xb=" + xb +
                ", mz='" + mz + '\'' +
                ", csrq=" + csrq +
                ", gj='" + gj + '\'' +
                ", zw='" + zw + '\'' +
                ", baydj='" + baydj + '\'' +
                ", lxdh='" + lxdh + '\'' +
                ", gatlx='" + gatlx + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
