package com.bcxin.obpm.dto.Ministerial;


import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 保安服务公司出资人信息上报实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "tlk_ShareholderInformation", extraWhere = "and item_domain_id in (select tlk_companyinformation.item_domain_id from tlk_companyinformation where item_officeType in ('0102','保安服务公司'))")
public class Bafwgsczrxx extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "(select item_companyCode from tlk_companyinformation where tlk_companyinformation.item_domain_id = t1.item_domain_id limit 1)", isSubQuery = true)
    private String bagsbm;
    /**
     * 是否法人股东
     */
    @MinisterialAttr(column = "if((select t11.id from tlk_ManagementLayer t11 where t11.item_domain_id = t1.item_domain_id  and t1.ITEM_documentID = t11.ITEM_documentID and ITEM_jobType ='3' limit 1) is null , 0, 1)", isSubQuery = true)
    private String sffr;
    /**
     * 法人股东名称
     */
    private String frmc;
    /**
     * 法人股东经济类型
     */
    private String jllx;
    /**
     * 股东证件号码
     */
    @MinisterialAttr(column = "ITEM_documentID")
    private String gdsfzh;
    /**
     * 自然人股东姓名
     */
    @MinisterialAttr(column = "ITEM_shareholder")
    private String gdxm;
    /**
     * 国籍（地区
     */
    @MinisterialAttr(column = "ITEM_nationality")
    private String gj;
    /**
     * 证件类型
     */
    @MinisterialAttr(column = "ITEM_shareholderType", DATA_FORMAT = MinisterialDataFormat.INVESTOR_CARD_TYPE)
    private String zjlx;
    /**
     * 证件号码
     */
    @MinisterialAttr(column = "ITEM_documentID")
    private String zjhm;
    /**
     * 性别
     */
    @MinisterialAttr(column = "ITEM_documentID", DATA_FORMAT = MinisterialDataFormat.GENDER)
    private String xb;
    /**
     * 出生日期
     */
    @MinisterialAttr(column = "ITEM_documentID", DATA_FORMAT = MinisterialDataFormat.BIRTH)
    private String csrq;
    /**
     * 民族
     */
    @MinisterialAttr(column = "ITEM_nation")
    private String mz;
    /**
     * 户籍地详址
     */
    @MinisterialAttr(column = "ITEM_household")
    private String xxdz;
    /**
     * 出资金额
     */
    @MinisterialAttr(column = "ITEM_capitalContribution", DATA_FORMAT = MinisterialDataFormat.CONVERSION_TO_YUAN)
    private String zzje;
    /**
     * 所占股份比例
     */
    @MinisterialAttr(column = "ITEM_stockProportion", DATA_FORMAT = MinisterialDataFormat.CONVERSION_TO_PERCENT)
    private String szbl;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;

    @Override
    public String toString() {
        return "Bafwgsczrxx{" +
                "bagsbm='" + bagsbm + '\'' +
                ", sffr=" + sffr +
                ", frmc='" + frmc + '\'' +
                ", jllx='" + jllx + '\'' +
                ", gdsfzh='" + gdsfzh + '\'' +
                ", gdxm='" + gdxm + '\'' +
                ", gj='" + gj + '\'' +
                ", zjlx='" + zjlx + '\'' +
                ", zjhm='" + zjhm + '\'' +
                ", xb=" + xb +
                ", csrq=" + csrq +
                ", mz='" + mz + '\'' +
                ", xxdz='" + xxdz + '\'' +
                ", zzje=" + zzje +
                ", szbl=" + szbl +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
