package com.bcxin.auth.schedule;

import cn.hutool.core.util.StrUtil;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.system.domain.DataSyncLog;
import com.bcxin.auth.system.dto.datasync.DataSyncDto;
import com.bcxin.auth.system.mapper.DataSyncLogMapper;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.auth.system.util.DataSyncInterfaceUtil;
import com.bcxin.obpm.dto.AuthAjaxResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Auther linqinglin
 * @date 2021/4/28 21:49
 */
@Component("dataSyncFtpTask")
public class DataSyncFtpTask {

    private static Logger logger = LoggerFactory.getLogger(DataSyncFtpTask.class);

    @Autowired
    ISysConfigService configService;

    @Autowired
    ConfigUtil configUtil;

    @Autowired
    DataSyncLogMapper dataSyncLogMapper;

    @Autowired
    DataSyncInterfaceUtil dataSyncInterfaceUtil;

    private boolean lock = false;

    public void run(){
        if(lock){
            return;
        }
        lock = true;

        try {
            if(configUtil.isIntranet()){
                List<DataSyncLog> dataSyncLogList = dataSyncLogMapper.findUnDataSyncList();
                if(dataSyncLogList.size() > 0){
                    DataSyncDto dataSyncDto = null;
                    AuthAjaxResult result = null;

                    List<DataSyncLog> saveList = new ArrayList<>();
                    for (DataSyncLog dataSyncLog : dataSyncLogList) {
                        try {
                            result = dataSyncInterfaceUtil.callInterface(Constants.DATASYNC_FTP_URL, dataSyncLog);
                            if(result.isSuccessful()){
                                dataSyncLog.setMsgId(result.getData().toString());
                                dataSyncLog.setDataSyncState(Constants.DATASYNCSTATE_1);
                                dataSyncLog.setErrorInfo(StrUtil.EMPTY);
                            }else{
                                dataSyncLog.setErrorInfo(result.getMsg());
                                if(dataSyncLog.getErrorInfo().length()>400) {
                                    dataSyncLog.setErrorInfo(dataSyncLog.getErrorInfo().substring(0, 400));
                                }
                            }

                            dataSyncLog.setUpdateTime(new Date());

                            saveList.add(dataSyncLog);
                        }catch (Exception e){
                            e.printStackTrace();
                        }
                    }
                    if(saveList.size() >0) {
                        dataSyncLogMapper.saveBatch(saveList);
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
        }finally {
            lock = false;
        }
    }

}
