package com.bcxin.auth.schedule;
import cn.hutool.core.util.StrUtil;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.system.domain.DataSyncLog;
import com.bcxin.auth.system.domain.SysConfig;
import com.bcxin.auth.system.mapper.DataSyncLogMapper;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Auther linqinglin
 * @date 2021/4/28 21:49
 */
@Component("dataSyncFileTask")
public class DataSyncFileTask {

    private static Logger logger = LoggerFactory.getLogger(DataSyncFileTask.class);

    @Autowired
    ISysConfigService configService;

    @Autowired
    ConfigUtil configUtil;

    @Autowired
    DataSyncLogMapper dataSyncLogMapper;

    private boolean lock = false;

    public void run() {
        if (lock) {
            return;
        }
        lock = true;

        try {
            if (configUtil.isIntranet()) {
                String beginDateStr = configService.selectConfigByKey(Constants.DATASYNC_DATE);
                Date beginDate = DateUtil.getBeginDayOfYesterday();
                if (StrUtil.isNotEmpty(beginDateStr)) {
                    beginDate = DateUtil.convertStringToDate(beginDateStr);
                }
                List<Date> dateList = DateUtil.getBetweenDates(beginDate, new Date());

                List<DataSyncLog> logList = new ArrayList<>();
                DataSyncLog dataSyncLog = null;
                for (Date date : dateList) {
                    String dirFilePath = BMSConfig.getDataSyncProfile() + DateUtil.convertDateToString(date, DateUtil.FORMAT2);
                    File dirFile = new File(dirFilePath);
                    if (!dirFile.exists()) {
                        continue;
                    }
                    File[] files = dirFile.listFiles();
                    for (File file : files) {
                        dataSyncLog = dataSyncLogMapper.findByFilePath(file.getAbsolutePath().replaceAll("\\\\", "/"));
                        if (dataSyncLog == null) {
                            dataSyncLog = new DataSyncLog();
                            dataSyncLog.setIsDelete(Constants.N);
                            dataSyncLog.setBasePath(BMSConfig.getDataSyncProfile());
                            dataSyncLog.setFilePath(file.getAbsolutePath().replaceAll("\\\\", "/"));
                            dataSyncLog.setFileName(file.getName());
                            dataSyncLog.setUrl("dataSync/getResource?path=" + dataSyncLog.getFilePath().replace(BMSConfig.getDataSyncProfile(), ""));
                            dataSyncLog.setBusinessType(Constants.DATASYNCTYPE_0);
                            dataSyncLog.setDataSyncState(Constants.DATASYNCSTATE_0);
                            dataSyncLog.setCreateTime(new Date());
                            dataSyncLog.setUpdateTime(new Date());
                            logList.add(dataSyncLog);
                        }
                    }
                }
                if (logList.size() > 0) {
                    int limit = 100;
                    //计算拆分次数
                    int count = new Double(Math.ceil(logList.size() * 1.0 / limit)).intValue();
                    //存放拆分数据
                    List<DataSyncLog> subList = null;
                    //循环拆分次数 生成相应数据文件
                    for (int i = 0; i < count; i++) {
                        subList = logList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                        dataSyncLogMapper.saveBatch(subList);
                    }
                }

                SysConfig dsDateConfig = new SysConfig();
                dsDateConfig.setConfigKey(Constants.DATASYNC_DATE);
                dsDateConfig.setConfigValue(DateUtil.getYesterday());
                configService.updateConfigByKey(dsDateConfig);

            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        } finally {
            lock = false;
        }
    }

}
