package com.bcxin.auth.system.mapper;

import com.bcxin.auth.system.domain.DataSyncLog;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 数据同步记录Dao接口
 * 
 * @author lin
 * @date 2020-12-07
 */
public interface DataSyncLogMapper {

    /****
     * 删除
     * @param dataSyncLog
     * @return
     */
    int delete(DataSyncLog dataSyncLog);

    /****
     * 保存
     * @param dataSyncLog
     * @return
     */
    int save(DataSyncLog dataSyncLog);

    /****
     * 主键查询
     * @param id
     * @return
     */
        DataSyncLog findById(Long id);

    /****
     * 选择修改
     * @param dataSyncLog
     * @return
     */
    int updateSelective(DataSyncLog dataSyncLog);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<DataSyncLog> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<DataSyncLog> findByBatchId(@Param("list") List<DataSyncLog> list);


    DataSyncLog findByMsgId(String msgId);

    DataSyncLog findByFilePath(String filePath);

    List<DataSyncLog> findUnDataSyncList();

    String findUnDSTime();
}
