
CREATE TABLE `sys_sms_log` (
  `smsId` bigint(20) NOT NULL COMMENT '短信日志ID',
  `phone` varchar(12) DEFAULT NULL COMMENT '手机号码',
  `msgcontext` varchar(255) DEFAULT NULL COMMENT '信息内容',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`smsId`),
  KEY `index_sys_sms_log_phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='短信日志表';


CREATE TABLE `product_coupon` (
  `productCouponId` bigint(20) NOT NULL COMMENT '产品优惠券ID(优惠券码)',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID(指内部人员)',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID(指内部人员)',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `productCategoryType` varchar(6) NOT NULL COMMENT '产品范畴类型',
  `name` varchar(50) DEFAULT NULL COMMENT '优惠券名称',
  `couponStatus` varchar(6) DEFAULT '0' COMMENT '优惠券状态',
  `discountWay` varchar(6) DEFAULT NULL COMMENT '优惠方式',
  `discountValue` decimal(8,2) DEFAULT NULL COMMENT '优惠值',
  `startTime` datetime DEFAULT NULL COMMENT '开始时间',
  `expireDays` int(6) DEFAULT NULL COMMENT '过期天数',
  `expireTime` datetime DEFAULT NULL COMMENT '过期时间',
  `remark` varchar(300) DEFAULT NULL COMMENT '备注',
  `useTime` datetime DEFAULT NULL COMMENT '使用时间',
  `comId` bigint(20) DEFAULT NULL COMMENT '使用企业ID',
  `comOrderId` bigint(20) DEFAULT NULL COMMENT '企业订单ID',
  PRIMARY KEY (`productCouponId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品优惠券';


CREATE TABLE `per_attend_card_record` (
  `attendCardRecordId` bigint(20) NOT NULL COMMENT '考勤打卡记录ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `setClockInTime` datetime DEFAULT NULL COMMENT '设置的打卡时间',
  `clockInDate` date NOT NULL COMMENT '打卡日期',
  `clockInTime` datetime DEFAULT NULL COMMENT '打卡时间',
  `clockInType` varchar(6) DEFAULT NULL COMMENT '打卡类别(上班打卡、下班打卡)',
  `clockInRound` int(3) DEFAULT NULL COMMENT '第几轮打卡',
  `placeLongitude` varchar(50) DEFAULT NULL COMMENT '打卡地点经度',
  `palceLatitude` varchar(50) DEFAULT NULL COMMENT '打卡地点纬度',
  `clockInWay` varchar(6) DEFAULT NULL COMMENT '打卡方式(wifi打卡、地点打卡)',
  `attendAddress` varchar(100) DEFAULT NULL COMMENT '打卡地点',
  `attendStatus` varchar(6) DEFAULT NULL COMMENT '考勤状态',
  `comId` bigint(20) NOT NULL COMMENT '所在企业ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  `shiftRuleId` bigint(20) DEFAULT NULL COMMENT '班次规则ID',
  `attendWifiId` bigint(20) DEFAULT NULL COMMENT '考勤WIFIID',
  `perId` bigint(20) NOT NULL COMMENT '打卡人员ID',
  `approveApplyId` bigint(20) DEFAULT NULL COMMENT '审批申请ID',
  `remark` varchar(50) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`attendCardRecordId`,`clockInDate`),
  KEY `index_per_attend_card_record_comId` (`comId`),
  KEY `index_per_attend_card` (`perId`,`clockInDate`,`clockInType`,`shiftId`,`shiftRuleId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤打卡记录';


INSERT INTO `sys_config` (`config_name`, `config_key`, `config_value`, `config_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('同一手机号当天发送次数上限', 'MSG_ONEDAY_MAXCOUNT', '8', 'Y', 'admin', '2021-06-21 11:13:42', '', NULL, NULL);
INSERT INTO `sys_config` (`config_name`, `config_key`, `config_value`, `config_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('短信发送状态(0:不打开,1:打开)', 'MSG_OPEN_STATE', '0', 'Y', 'admin', '2021-06-21 11:14:27', '', NULL, NULL);


