package com.bcxin.platform.web.controller.meeting;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.meeting.PerHuaweiMeetMatchDto;
import com.bcxin.platform.service.meeting.PerHuaweiMeetMatchService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 人员华为云会议映射
 *
 * @author llc
 * @date 2019-12-10
 */
@Api("人员华为云会议映射")
@RestController
@RequestMapping("/per-huawei-meet-match")
public class PerHuaweiMeetMatchController extends BaseController {

    @Resource
    private PerHuaweiMeetMatchService perHuaweiMeetMatchService;

    /**
     * 华为云鉴权
     *
     * @param perHuaweiMeetMatch
     * @return
     * @auth llc
     * @date 2019-12-10
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员华为云会议映射", title = "华为云鉴权", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-huawei-accesstoken")
    @ApiOperation(value = "华为云鉴权", httpMethod = "POST", notes = "华为云鉴权", response = PerHuaweiMeetMatch.class)
    public Result getHuaweiAccessToken(PerHuaweiMeetMatch perHuaweiMeetMatch) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        perHuaweiMeetMatch.setPerId(currentUser.getPerId());
        return perHuaweiMeetMatchService.getHuaweiAccessToken(perHuaweiMeetMatch).setBack(getRequest());
    }

    /**
     * 新增用户
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2019-12-10
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员华为云会议映射", title = "新增用户", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "add-user")
    @ApiOperation(value = "新增用户", httpMethod = "POST", notes = "新增用户", response = PerHuaweiMeetMatchDto.class)
    public Result addUser(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perHuaweiMeetMatchService.addUser(dto).setBack(getRequest());
    }

    /**
     * 设置监管机构负责人
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-12-03
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员华为云会议映射", title = "设置监管机构负责人", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "set-regulator-meet-charge")
    @ApiOperation(value = "设置监管机构负责人", httpMethod = "POST", notes = "设置监管机构负责人", response = Result.class)
    public Result setRegulatorMeetCharge(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perHuaweiMeetMatchService.setRegulatorMeetCharge(dto).setBack(getRequest());
    }


    /**
     * 取消监管机构负责人
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-12-03
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员华为云会议映射", title = "取消监管机构负责人", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "cancel-regulator-meet-charge")
    @ApiOperation(value = "取消监管机构负责人", httpMethod = "POST", notes = "取消监管机构负责人", response = Result.class)
    public Result cancelRegulatorMeetCharge(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perHuaweiMeetMatchService.cancelRegulatorMeetCharge(dto).setBack(getRequest());
    }


    /**
     * 批量删除用户
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2019-12-12
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员华为云会议映射", title = "批量删除用户", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "batch-delete-user")
    @ApiOperation(value = "批量删除用户", httpMethod = "POST", notes = "批量删除用户", response = PerHuaweiMeetMatchDto.class)
    public Result batchDeleteUser(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perHuaweiMeetMatchService.batchDeleteUser(dto).setBack(getRequest());
    }


    /**
     * 发送华为云会议通知短信
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2019-12-17
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员华为云会议映射", title = "发送华为云会议通知短信", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "send-huawei-meet-sms")
    @ApiOperation(value = "发送华为云会议通知短信", httpMethod = "POST", notes = "发送华为云会议通知短信", response = PerHuaweiMeetMatchDto.class)
    public Result sendHuaweiMeetSms(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perHuaweiMeetMatchService.sendHuaweiMeetSms(dto).setBack(getRequest());
    }


    /**
     * 获取录播文件列表
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-02-03
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员华为云会议映射", title = "获取录播文件列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-transcribe-file-list")
    @ApiOperation(value = "获取录播文件列表", httpMethod = "GET", notes = "获取录播文件列表", response = Result.class)
    public Result getTranscribeFileList(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        return perHuaweiMeetMatchService.getTranscribeFileList(dto).setBack(getRequest());
    }


    /**
     * 批量删除录播文件
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-02-03
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员华为云会议映射", title = "批量删除录播文件", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "batch-delete-transcribe-file")
    @ApiOperation(value = "批量删除录播文件", httpMethod = "POST", notes = "批量删除录播文件", response = Result.class)
    public Result batchDeleteTranscribeFile(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        return perHuaweiMeetMatchService.batchDeleteTranscribeFile(dto).setBack(getRequest());
    }


    /**
     * 查询会议列表
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-10-12
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员华为云会议映射", title = "查询会议列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-huawei-meet-list")
    @ApiOperation(value = "查询会议列表", httpMethod = "POST", notes = "查询会议列表", response = Result.class)
    public Result getHuaweiMeetList(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        Result result = perHuaweiMeetMatchService.getHuaweiMeetList(dto).setBack(getRequest());
        return result;
    }

    /**
     * 查询会议详情
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-10-13
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员华为云会议映射", title = "查询会议详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-huawei-meet-detail")
    @ApiOperation(value = "查询会议详情", httpMethod = "POST", notes = "查询会议详情", response = Result.class)
    public Result getHuaweiMeetDetail(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        return perHuaweiMeetMatchService.getHuaweiMeetDetail(dto).setBack(getRequest());
    }

}
