package com.bcxin.platform.web.controller.attend;

import cn.hutool.core.util.StrUtil;
import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendDto;
import com.bcxin.platform.service.attend.AttendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤套Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/attend")
public class AttendController extends BaseController{

    @Autowired
    private AttendService attendService;

    /**
     * 查询考勤套列表
     */
    @PostMapping("/list")
    public TableDataInfo list(AttendDto attend){
        List<Attend> list = attendService.selectList(attend);
        return getDataTable(list);
    }

    /**
     * 分页查询考勤套列表
     */
    @PostMapping("/searchForPage")
    public TableDataInfo searchForPage(AttendDto attend){
        startPage();
        List<Attend> list = attendService.selectList(attend);
        return getDataTable(list);
    }

    /**
     * 修改考勤套
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        Attend attend = attendService.findById(id);
        return AjaxResult.success(null,attend);
    }

    /**
     * 保存考勤套
     */
    @Log(title = "考勤套", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(Attend attend){
        ValidatorUtils.validateEntity(attend, AddGroup.class);
        return toAjax(attendService.update(attend));
    }

    /**
     * 删除考勤套
     */
    @Log(title = "考勤套", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendService.deleteByIds(ids));
    }

    /**
     * 获取剩余补卡次数
     */
    @GetMapping("/getCountLimit")
    public AjaxResult getCountLimit(AppAttendSearchDto searchDto){
        CurrentUser currentUser = new CurrentUser(getRequest());
        searchDto.setPerId(currentUser.getPerId());
        if(StrUtil.isEmpty(searchDto.getSchedulDate())){
            searchDto.setSchedulDate(DateUtils.dateTimeNow(DateUtils.YYYY_MM));
        }else {
            searchDto.setSchedulDate(searchDto.getSchedulDate().substring(0,7));
        }
        Integer countLimit = attendService.getCountLimit(searchDto);
        return AjaxResult.success(countLimit);
    }

}
