package com.bcxin.platform.web.controller.attend;

import cn.hutool.core.util.StrUtil;
import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.domain.attend.AttendCalendarRest;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.attend.AttendCalendarRestDetailDto;
import com.bcxin.platform.service.attend.AttendCalendarRestDetailService;
import com.bcxin.platform.service.attend.AttendCalendarRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 考勤打卡日历套-日历Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/attend/rest")
public class AttendCalendarRestController extends BaseController{

    @Autowired
    private AttendCalendarRestService attendCalendarRestService;

    @Autowired
    private AttendCalendarRestDetailService attendCalendarRestDetailService;


    /**
     * 分页查询考勤打卡日历套-日历列表
     */
    @PostMapping("/searchForPage")
    public TableDataInfo searchForPage(AttendCalendarRestDetailDto attendCalendarDetail){
        startPage();
        List<AttendCalendarRestDetailDto> list = attendCalendarRestDetailService.selectList(attendCalendarDetail);
        return getDataTable(list);
    }

    /**
     * 导出考勤打卡日历套-日历列表
     */
    @Log(title = "考勤打卡日历套-日历", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public AjaxResult export(AttendCalendarRestDetailDto attendCalendarDetail){
        List<AttendCalendarRestDetailDto> list = attendCalendarRestService.selectList(attendCalendarDetail);
        ExcelUtil<AttendCalendarRestDetailDto> util = new ExcelUtil<AttendCalendarRestDetailDto>(AttendCalendarRestDetailDto.class);
        return util.exportExcel(list, "detail");
    }
    /**
     * 导入考勤打卡日历套-日历列表
     */
    @Log(title = "考勤打卡日历套-日历", businessType = BusinessType.IMPORT)
    @PostMapping("/import")
    public AjaxResult importData(MultipartFile file,Long calendarId){
        try {
            if(calendarId == null){
                return AjaxResult.error("日历套不能为空");
            }
            CurrentUser currentUser = new CurrentUser(getRequest());
            ExcelUtil<AttendCalendarRest> util = new ExcelUtil<AttendCalendarRest>(AttendCalendarRest.class);
            List<AttendCalendarRest> restList = util.importExcel(file.getInputStream());
            for (AttendCalendarRest calendarRest : restList) {
                if(StrUtil.isEmpty(calendarRest.getCalendarType())){
                    return AjaxResult.error("日历类型不能为空");
                }

                if("休息日".equals(calendarRest.getCalendarType())){
                    calendarRest.setCalendarType("1");
                }else if("法定假日".equals(calendarRest.getCalendarType())){
                    calendarRest.setCalendarType("2");
                }else{
                    return AjaxResult.error("日历类型错误");
                }

                if(calendarRest.getStartDate() == null){
                    return AjaxResult.error("开始日期不能为空");
                }
                if(calendarRest.getEndDate() == null){
                    return AjaxResult.error("开始日期不能为空");
                }

                calendarRest.setCalendarId(calendarId);
                calendarRest.setCreateBy(currentUser.getPerId().toString());
                calendarRest.setUpdateBy(currentUser.getPerId().toString());
            }
            attendCalendarRestService.saveBatch(restList);
        }catch (Exception e){
            return AjaxResult.error("导入失败："+e.getMessage());
        }
        return AjaxResult.success("导入成功！");
    }

    /**
     * 修改考勤打卡日历套-日历
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendCalendarRest attendCalendarDetail = attendCalendarRestService.findById(id);
        return AjaxResult.success(null,attendCalendarDetail);
    }

    /**
     * 保存考勤打卡日历套-日历
     */
    @Log(title = "考勤打卡日历套-日历", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(AttendCalendarRest attendCalendarRest){
        ValidatorUtils.validateEntity(attendCalendarRest, AddGroup.class);
        return toAjax(attendCalendarRestService.update(attendCalendarRest));
    }

    /**
     * 删除考勤打卡日历套-日历
     */
    @Log(title = "考勤打卡日历套-日历", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendCalendarRestDetailService.deleteByIds(ids));
    }
}
