package com.bcxin.platform.web.controller.app.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.domain.attend.AttendClockDetail;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.service.attend.AttendClockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 考勤打卡记录Controller
 * 
 * @author lin
 * @date 2021-08-27
 */
@RestController
@RequestMapping("/app/attend/clock")
public class AppAttendClockController extends BaseController{

    @Autowired
    private AttendClockService attendClockService;

    /**
     * 修改保存考勤打卡记录
     */
    @Log(title = "考勤打卡记录", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult saveClock(AttendClockDetail attendClockDetail){
        return toAjax(attendClockService.saveClock(attendClockDetail));
    }

}
