/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util;

import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    public static final int RESCODE_SUCCESS = 1000;
    public static final int RESCODE_SUCCESS_MSG = 1001;
    public static final int RESCODE_EXCEPTION = 1002;
    public static final int RESCODE_NOLOGIN = 1003;
    public static final int RESCODE_NOEXIST = 1004;
    public static final int RESCODE_NOAUTH = 1005;
    public static final String JWT_SECRET = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr";
    public static final int JWT_TTL = 1471228928;
    public static final int JWT_REFRESH_INTERVAL = 3300000;
    public static final int JWT_REFRESH_TTL = 604800000;

    private static SecretKey generalKey(String stringKey) {
        byte[] encodedKey = Base64.decodeBase64((String)stringKey);
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }

    public static String createJWT(String id, String subject, String stringKey, long ttlMillis) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(new Date(System.currentTimeMillis())).setSubject(subject).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static String createJWT(Map<Object, Object> subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(JWT_SECRET));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static String createJWTObject(Object subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString((Object)subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(JWT_SECRET));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static String createJWT(Map<Object, Object> subject, String stringKey, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static Claims parseJWT(String jwttoken) {
        Claims claims = (Claims)Jwts.parser().setSigningKey((Key)JwtUtil.generalKey(JWT_SECRET)).parseClaimsJws(jwttoken).getBody();
        return claims;
    }

    public static void main(String[] args) throws Exception {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("MerUserId", "664891052041175040");
        p.put("VirlAcctType", "01");
        p.put("BeginDate", "2020-11-20");
        p.put("EndDate", "2020-12-01");
        String token = JwtUtil.createJWT(p);
        System.out.println(token);
        Claims claims = JwtUtil.parseJWT(token);
        System.out.println(claims.getSubject());
        String paramStr = claims.getSubject();
        Map paramMap = (Map)JSON.parseObject((String)paramStr, Map.class);
        System.out.println(paramMap);
    }
}

