/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.system.impl;

import com.bcxin.platform.common.core.domain.entity.SysDictData;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DictUtils;
import com.bcxin.platform.mapper.system.SysDictDataMapper;
import com.bcxin.platform.service.system.ISysDictDataService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class SysDictDataServiceImpl
implements ISysDictDataService {
    @Autowired
    private SysDictDataMapper dictDataMapper;

    @Override
    public List<SysDictData> selectDictDataList(SysDictData dictData) {
        return this.dictDataMapper.selectDictDataList(dictData);
    }

    @Override
    public String selectDictLabel(String dictType, String dictValue) {
        return this.dictDataMapper.selectDictLabel(dictType, dictValue);
    }

    @Override
    public SysDictData selectDictDataById(Long dictCode) {
        return this.dictDataMapper.selectDictDataById(dictCode);
    }

    @Override
    public int deleteDictDataByIds(String ids) {
        int row = this.dictDataMapper.deleteDictDataByIds(Convert.toStrArray((String)ids));
        if (row > 0) {
            DictUtils.clearDictCache();
        }
        return row;
    }

    @Override
    public int insertDictData(SysDictData dictData) {
        int row = this.dictDataMapper.insertDictData(dictData);
        if (row > 0) {
            DictUtils.clearDictCache();
        }
        return row;
    }

    @Override
    public int updateDictData(SysDictData dictData) {
        int row = this.dictDataMapper.updateDictData(dictData);
        if (row > 0) {
            DictUtils.clearDictCache();
        }
        return row;
    }
}

