package com.bcxin.platform.dto.company;

import com.bcxin.platform.domain.company.ComDepart;
import com.bcxin.platform.util.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 人员信息列表查询dto
 * @date 2019-05-17
 * @author：llc
 */
@Data
public class PerInfoQueryDto extends BaseEntity<ComDepart> {

	/**
	 * 关键字
	 */
	@ApiModelProperty(value = "关键字")
	private String keyWord;

	/**
	 * 部门ID
	 */
	@ApiModelProperty(value = "部门ID")
	private Long departId;

	/**
	 * 人员类型
	 */
	@ApiModelProperty(value = "人员类型")
	private String perType;

	/**
	 * app激活状态
	 */
	@ApiModelProperty(value = "app激活状态")
	private String isAppActive;

	/**
	 * 认证状态
	 */
	@ApiModelProperty(value = "认证状态")
	private String authStatus;

	/**
	 * 入职开始日期
	 */
	@ApiModelProperty(value = "入职开始日期")
	private Date entryStartDate;

	/**
	 * 入职结束日期
	 */
	@ApiModelProperty(value = "入职结束日期")
	private Date entryEndDate;

	/**
	 * 持证状态
	 */
	@ApiModelProperty(value = "持证状态")
	private String czzt;

	/**
	 * 投保状态
	 */
	@ApiModelProperty(value = "投保状态")
	private String tbzt;

	/**
	 * 申诉状态
	 */
	@ApiModelProperty(value = "申诉状态")
	private String sszt;

	/**
	 * 保安证书等级
	 */
	@ApiModelProperty(value = "保安证书等级")
	private String perCerLevel;

	/**
	 * 人员ID
	 */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/**
	 * 数据权限类型
	 */
	@ApiModelProperty(value = "数据权限类型")
	private String dataAuthType;

	/**
	 * 部门列表
	 */
	@ApiModelProperty(value = "部门列表")
	private List<Long> orgIdList;

	/**
	 * 是否关联合同
	 */
	@ApiModelProperty(value = "是否关联合同")
	private String isRelationContract;

	/**
	 * 是否完成学习
	 */
	@ApiModelProperty(value = "是否完成学习")
	private String isFinishLearn;

	/**
	 * 部门ID集合
	 */
	@ApiModelProperty(value = "部门ID集合")
	private String departIds;


	/**
	 * 部门Id列表
	 */
	@ApiModelProperty(value = "部门Id列表")
	private List<Long> departIdList;


	/**
	 * 最小年龄
	 */
	@ApiModelProperty(value = "最小年龄")
	private Integer minAge;

	/**
	 * 最大年龄
	 */
	@ApiModelProperty(value = "最大年龄")
	private Integer maxAge;


	/**
	 * 监管会议负责人类型
	 */
	@ApiModelProperty(value = "监管会议负责人类型")
	private String regulatorMeetChargeType;

	/**
	 * 姓名
	 */
	@ApiModelProperty(value = "姓名")
	private String name;

	/**
	 * 注册地所在省份
	 */
	@ApiModelProperty(value = "注册地所在省份")
	private Integer regProvince;



}
