package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.Map;

/**
 * @author linqinglin
 * @date 2021/08/12 0012 13:20
 */
@Data
public class AttendSchedulPerPageDto extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 考勤排班ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 考勤套ID */
    @Excel(name = "考勤套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long attendId;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long deptId;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    private String name;

    private String departName;

    private String schedulDate;

    private String shiftName;

    private String startTime;

    private String endTime;

    private String shiftHour;
    /**
     * 休息时长
     */
    private String restHour;

    private String attendName;

    private String creator;

    private String schedulType;

    /** 请求参数 */
    private Map<String, Object> params;
}
