package com.bcxin.platform.domain.attend;

import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.OneGroup;
import com.bcxin.platform.common.utils.validator.group.TwoGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 考勤套对象 tb_attend
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class Attend extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 考勤套ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 名称 */
    @Excel(name = "名称")
    @NotBlank(message="考勤套名称不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String attendName;

    /** 是否启用 1是0否 */
    @Excel(name = "是否启用 1是0否")
    @NotBlank(message="是否启用不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String active;

    @Excel(name = "班次类型 1计时班次 2 计次班次")
    @NotBlank(message="班次类型不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String shiftType;

    /** 是否限制外出跨月 1是0否 */
    @Excel(name = "是否限制外出跨月 1是0否")
    @NotBlank(message="是否限制外出跨月不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String outLimit;

    @Excel(name = "打卡类型 0定位1wifi")
    @NotBlank(message="打卡类型", groups = {AddGroup.class,UpdateGroup.class})
    private String clockType;

    /** 是否开启人脸认证 1是0否 */
    @Excel(name = "是否开启人脸认证 1是0否")
    @NotBlank(message="是否开启人脸认证不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String face;

    /** 补卡次数限制 */
    @Excel(name = "补卡次数限制")
    private Integer countLimit;

    /** 是否限制请假跨月 1是0否 */
    @Excel(name = "是否限制请假跨月 1是0否")
    @NotBlank(message="是否限制请假跨月不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String leaveLimit;

    /** 是否开启假别超支提醒 1是0否 */
    @Excel(name = "是否开启假别超支提醒 1是0否")
    @NotBlank(message="是否开启假别超支提醒不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String overRemind;

    /** 同假别的请假单是否允许同时提交 1是0否 */
    @Excel(name = "同假别的请假单是否允许同时提交 1是0否")
    @NotBlank(message="同假别的请假单是否允许同时提交不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String sameLimit;

    /** 最小加班单位 */
    @Excel(name = "最小加班单位")
    @NotBlank(message="最小加班单位不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String minUnit;

    /** 加班开始,结束是否要刷卡 1是0否 */
    @Excel(name = "加班开始,结束是否要刷卡 1是0否")
    @NotBlank(message="加班开始,结束是否要刷卡不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String clockIn;

    /** 公司ID */
    @Excel(name = "公司ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="公司ID不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private Long comId;

    /**
     * 部门id
     */
    private Long deptId;

    /**
     * 负责人id
     */
    @NotEmpty(message="负责人id不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String[] chargeIds;

    /**
     * 负责人列表
     */
    private List<PerBaseInfo> chargeList;

    @NotEmpty(message="打卡地点设置不能为空", groups = {OneGroup.class})
    private List<AttendAddress> addressList;

    @NotEmpty(message="wifi设置不能为空", groups = {TwoGroup.class})
    private List<AttendWifi> wifiList;

    private Integer perNum;

    public static void main(String[] args) {
        Attend attend = new Attend();
        attend.setId(0L);
        attend.setAttendName("");
        attend.setActive("");
        attend.setOutLimit("");
        attend.setFace("");
        attend.setCountLimit(0);
        attend.setLeaveLimit("");
        attend.setOverRemind("");
        attend.setSameLimit("");
        attend.setMinUnit("");
        attend.setClockIn("");

        System.out.println(JSON.toJSONString(attend));

    }
}
