package com.bcxin.platform.config;

import com.alibaba.fastjson.JSON;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;
import java.net.URL;

/**
 * <b>  </b>
 * @author ZXF
 * @create 2023/04/01 0001 16:35
 * @version
 * @注意事项 </b>
 */
@Configuration
public class RedissonConfig {
    @Bean
    public RedissonClient redisson() throws IOException {
        URL resource = RedissonConfig.class.getClassLoader().getResource("redisson-config.yml");
        System.out.println("=========> Resource URL: " + JSON.toJSONString(resource));
        System.out.println("=========> Resource Path: " + resource.getPath());
        Config config = Config.fromYAML(resource);
        return Redisson.create(config);
    }
}
