/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.oaflow.domain.MakeUpCard;
import com.bcxin.oaflow.domain.OaBusinessBaseEntity;
import com.bcxin.oaflow.dto.MakeUpCardDto;
import com.bcxin.oaflow.mapper.MakeUpCardMapper;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendClock;
import com.bcxin.platform.domain.attend.AttendClockDetail;
import com.bcxin.platform.domain.attend.AttendSchedulDetail;
import com.bcxin.platform.domain.attend.AttendShift;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.dto.attend.AttendClockStateDto;
import com.bcxin.platform.mapper.attend.AttendClockDetailMapper;
import com.bcxin.platform.mapper.attend.AttendClockMapper;
import com.bcxin.platform.mapper.attend.AttendReportMapper;
import com.bcxin.platform.mapper.attend.AttendSchedulDetailMapper;
import com.bcxin.platform.mapper.attend.AttendShiftMapper;
import com.bcxin.platform.service.attend.AttendClockService;
import com.bcxin.platform.timer.AttendReportTask;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class AttendClockServiceImpl
implements AttendClockService {
    @Autowired
    private AttendSchedulDetailMapper attendSchedulMapper;
    @Autowired
    private AttendClockMapper attendClockMapper;
    @Autowired
    private AttendClockDetailMapper attendClockDetailMapper;
    @Autowired
    private MakeUpCardMapper makeUpCardMapper;
    @Autowired
    private AttendReportMapper attendReportMapper;
    @Autowired
    private AttendShiftMapper attendShiftMapper;
    @Resource
    private IdWorker idWorker;
    @Resource
    private AttendReportTask attendReportTask;

    @Override
    public AttendClock findById(Long id) {
        return this.attendClockMapper.findById(id);
    }

    @Override
    public List<AttendClockDto> selectList(AttendClockDto searchDto) {
        if (!(searchDto.isDomainAdmin() || searchDto.getAdminDepartIds() != null && searchDto.getAdminDepartIds().size() != 0)) {
            return new ArrayList<AttendClockDto>();
        }
        return this.attendClockMapper.selectList(searchDto);
    }

    @Override
    public int update(AttendClock attendClock) {
        AttendClock dbAttendClock = this.attendClockMapper.findById(attendClock.getSchedulDetailId());
        if (dbAttendClock == null) {
            attendClock.setCreateTime(DateUtils.getNowDate());
            attendClock.setIsDelete("0");
        } else {
            attendClock.setClockStart(dbAttendClock.getClockStart());
            BeanUtils.copyPropertiesIgnore((Object)((Object)attendClock), (Object)((Object)dbAttendClock), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbAttendClock), (Object)((Object)attendClock), (Boolean)false);
        }
        AttendSchedulDetail attendSchedul = this.attendSchedulMapper.findById(attendClock.getSchedulDetailId());
        Integer restMinu = 0;
        if ("1".equals(attendSchedul.getNeedRest())) {
            restMinu = DateUtils.minDiff((String)attendSchedul.getRestStart(), (String)attendSchedul.getRestEnd()).intValue();
        }
        Integer lateMin = 0;
        if (attendClock.getLateMin() == null && StrUtil.isNotEmpty((CharSequence)attendClock.getClockStart())) {
            Date startTime = DateUtils.parseDate((Object)attendSchedul.getStartTime());
            Date endTime = DateUtils.parseDate((Object)attendClock.getClockStart());
            if (startTime.getTime() < endTime.getTime()) {
                Integer actualRestMinu = 0;
                if ("1".equals(attendSchedul.getNeedRest())) {
                    Date restStart = DateUtils.parseDate((Object)attendSchedul.getRestStart());
                    Date restEnd = DateUtils.parseDate((Object)attendSchedul.getRestEnd());
                    if (endTime.getTime() > restStart.getTime() && endTime.getTime() < restEnd.getTime()) {
                        endTime = restStart;
                    } else if (endTime.getTime() >= restStart.getTime()) {
                        actualRestMinu = restMinu;
                    }
                }
                if ((lateMin = Integer.valueOf(DateUtils.minDiff((Date)startTime, (Date)endTime).intValue() - actualRestMinu)) > 0) {
                    attendClock.setClockStatus("3");
                }
            }
            attendClock.setLateMin(lateMin);
        }
        if ("1".equals(attendClock.getShiftType())) {
            Integer leaveEarly = 0;
            if (attendClock.getLeaveEarly() == null && StrUtil.isNotEmpty((CharSequence)attendClock.getClockEnd())) {
                Date startTime = DateUtils.parseDate((Object)attendClock.getClockEnd());
                Date endTime = DateUtils.parseDate((Object)attendSchedul.getEndTime());
                if (startTime.getTime() < endTime.getTime()) {
                    Integer actualRestMinu = 0;
                    if ("1".equals(attendSchedul.getNeedRest())) {
                        Date restStart = DateUtils.parseDate((Object)attendSchedul.getRestStart());
                        Date restEnd = DateUtils.parseDate((Object)attendSchedul.getRestEnd());
                        if (startTime.getTime() > restStart.getTime() && startTime.getTime() < restEnd.getTime()) {
                            startTime = restEnd;
                        } else if (endTime.getTime() <= restStart.getTime()) {
                            actualRestMinu = restMinu;
                        }
                    }
                    if ((leaveEarly = Integer.valueOf(DateUtils.minDiff((Date)startTime, (Date)endTime).intValue() - actualRestMinu)) > 0) {
                        if ("3".equals(attendClock.getClockStatus())) {
                            attendClock.setClockStatus("34");
                        } else {
                            attendClock.setClockStatus("4");
                        }
                    }
                }
                attendClock.setLeaveEarly(leaveEarly);
            }
            if (StrUtil.isEmpty((CharSequence)attendClock.getClockStart())) {
                attendClock.setClockStatus("21");
                if (leaveEarly > 0) {
                    attendClock.setClockStatus("24");
                }
            }
            if (StrUtil.isEmpty((CharSequence)attendClock.getClockStatus()) && StrUtil.isNotEmpty((CharSequence)attendClock.getClockStart()) && StrUtil.isNotEmpty((CharSequence)attendClock.getClockEnd())) {
                attendClock.setClockStatus("1");
            }
        } else if (StrUtil.isEmpty((CharSequence)attendClock.getClockStatus()) && StrUtil.isNotEmpty((CharSequence)attendClock.getClockStart())) {
            attendClock.setClockStatus("1");
        }
        attendClock.setUpdateTime(DateUtils.getNowDate());
        return this.attendClockMapper.save(attendClock);
    }

    @Override
    public int saveClock(AttendClockDetail attendClockDetail) {
        if (attendClockDetail.getId() == null) {
            attendClockDetail.setCreateTime(DateUtils.getNowDate());
            attendClockDetail.setId(this.idWorker.nextId());
            attendClockDetail.setIsDelete("0");
        } else {
            AttendClockDetail dbAttendClockDetail = this.attendClockDetailMapper.findById(attendClockDetail.getId());
            BeanUtils.copyPropertiesIgnore((Object)((Object)attendClockDetail), (Object)((Object)dbAttendClockDetail), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbAttendClockDetail), (Object)((Object)attendClockDetail), (Boolean)false);
        }
        attendClockDetail.setClockTime(DateUtils.getNowDate());
        attendClockDetail.setUpdateTime(DateUtils.getNowDate());
        AttendClock attendClock = this.attendClockMapper.findById(attendClockDetail.getSchedulDetailId());
        if (attendClock == null) {
            attendClock = new AttendClock();
        }
        BeanUtils.copyPropertiesIgnore((Object)((Object)attendClockDetail), (Object)((Object)attendClock), (Boolean)true);
        AttendSchedulDetail attendSchedulDetail = this.attendSchedulMapper.findById(attendClockDetail.getSchedulDetailId());
        AttendShift attendShift = this.attendShiftMapper.findById(attendSchedulDetail.getShiftId());
        attendClock.setShiftType(attendShift.getShiftType());
        if ("1".equals(attendClock.getShiftType())) {
            if (StrUtil.isEmpty((CharSequence)attendClock.getClockStart())) {
                if (DateUtils.parseDate((Object)attendSchedulDetail.getEndTime()).getTime() < DateUtils.getNowDate().getTime()) {
                    attendClock.setClockEnd(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)attendClockDetail.getClockTime()));
                } else {
                    attendClock.setClockStart(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)attendClockDetail.getClockTime()));
                }
            } else {
                attendClock.setClockEnd(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)attendClockDetail.getClockTime()));
            }
        } else {
            attendClock.setClockStart(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM, (Date)attendClockDetail.getClockTime()));
        }
        attendClock.setClockSource("1");
        this.update(attendClock);
        return this.attendClockDetailMapper.save(attendClockDetail);
    }

    @Override
    public int deleteByIds(String ids) {
        return this.attendClockMapper.deleteByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int updateState(AttendClockStateDto clockDetailDto) {
        List<AttendClock> clockList = this.attendClockMapper.findByIds(Convert.toStrArray((String)clockDetailDto.getIds()));
        if (clockList.size() == 0) {
            throw new BusinessException("ids\u9519\u8bef");
        }
        ArrayList<AttendClock> updateList = new ArrayList<AttendClock>();
        String opName = null;
        AttendSchedulDetail schedulDetail = null;
        for (AttendClock attendClock : clockList) {
            if (attendClock.getClockStatus() == null || "1".equals(attendClock.getClockStatus())) continue;
            schedulDetail = this.attendSchedulMapper.findById(attendClock.getSchedulDetailId());
            switch (attendClock.getClockStatus()) {
                case "21": {
                    opName = "\u4e0a\u73ed\u7f3a\u5361";
                    attendClock.setClockStart(schedulDetail.getStartTime());
                    break;
                }
                case "22": {
                    opName = "\u4e0b\u73ed\u7f3a\u5361";
                    attendClock.setClockEnd(schedulDetail.getEndTime());
                    break;
                }
                case "23": {
                    opName = "\u4e0b\u73ed\u7f3a\u5361\uff0c\u8fdf\u5230";
                    attendClock.setClockStart(schedulDetail.getStartTime());
                    attendClock.setClockEnd(schedulDetail.getEndTime());
                    opName = opName + attendClock.getLateMin() + "\u5206\u949f";
                    break;
                }
                case "24": {
                    opName = "\u4e0a\u73ed\u7f3a\u5361\uff0c\u65e9\u9000";
                    attendClock.setClockStart(schedulDetail.getStartTime());
                    attendClock.setClockEnd(schedulDetail.getEndTime());
                    opName = opName + attendClock.getLeaveEarly() + "\u5206\u949f";
                    break;
                }
                case "3": {
                    attendClock.setClockStart(schedulDetail.getStartTime());
                    opName = "\u8fdf\u5230" + attendClock.getLateMin() + "\u5206\u949f";
                    break;
                }
                case "4": {
                    attendClock.setClockEnd(schedulDetail.getEndTime());
                    opName = "\u65e9\u9000" + attendClock.getLeaveEarly() + "\u5206\u949f";
                    break;
                }
                case "34": {
                    attendClock.setClockStart(schedulDetail.getStartTime());
                    attendClock.setClockEnd(schedulDetail.getEndTime());
                    opName = "\u8fdf\u5230" + attendClock.getLateMin() + "\u5206\u949f,\u65e9\u9000" + attendClock.getLeaveEarly() + "\u5206\u949f";
                    break;
                }
                case "5": {
                    attendClock.setClockStart(schedulDetail.getStartTime());
                    if ("1".equals(attendClock.getShiftType())) {
                        attendClock.setClockEnd(schedulDetail.getEndTime());
                    }
                    opName = "\u6f0f\u5361";
                    break;
                }
            }
            attendClock.setSchedulDetail(schedulDetail);
            attendClock.setClockStatus("1");
            attendClock.setUpdateBy(clockDetailDto.getCreateBy());
            attendClock.setUpdateTime(DateUtils.getNowDate());
            attendClock.setRemark("\u3010" + clockDetailDto.getCreateName() + "\u3011\u64cd\u4f5c\u3010" + opName + "\u3011\u8f6c\u3010\u6b63\u5e38\u3011");
            attendClock.setClockSource("3");
            updateList.add(attendClock);
        }
        if (updateList.size() == 0) {
            throw new BusinessException("\u6ca1\u6709\u9700\u8981\u64cd\u4f5c\u8865\u5361\u7684\u6570\u636e");
        }
        this.attendClockMapper.saveBatch(updateList);
        for (AttendClock attendClock : updateList) {
            if ("2".equals(attendClock.getShiftType())) {
                if (DateUtils.parseDate((Object)attendClock.getSchedulDetail().getStartTime()).getTime() >= DateUtils.getNowDate().getTime()) continue;
                this.attendReportTask.createDayReport(attendClock.getSchedulDetail().getSchedulDate(), false, attendClock.getSchedulDetail().getPerId());
                if (DateUtils.parseDate((Object)attendClock.getSchedulDetail().getSchedulDate()).getTime() >= DateUtils.getNowDate().getTime()) continue;
                this.attendReportMapper.updateMonthReport(attendClock.getSchedulDetail());
                continue;
            }
            if (DateUtils.parseDate((Object)attendClock.getSchedulDetail().getEndTime()).getTime() >= DateUtils.getNowDate().getTime()) continue;
            this.attendReportTask.createDayReport(attendClock.getSchedulDetail().getSchedulDate(), false, attendClock.getSchedulDetail().getPerId());
            if (DateUtils.parseDate((Object)attendClock.getSchedulDetail().getSchedulDate()).getTime() >= DateUtils.getNowDate().getTime()) continue;
            this.attendReportMapper.updateMonthReport(attendClock.getSchedulDetail());
        }
        return updateList.size();
    }

    @Override
    public List<MakeUpCardDto> getMissCard(AttendClockDto searchDto) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("unInClockStatus", new String[]{"1"});
        paramMap.put("beginTime", DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)DateUtil.beginOfMonth((Date)DateUtils.addMonths((Date)DateUtils.getNowDate(), (int)-1)).toJdkDate()));
        paramMap.put("endTime", DateUtils.getDate());
        searchDto.setParams(paramMap);
        List<AttendClockDto> clockDtoList = this.attendClockMapper.selectListForReport(searchDto);
        List<MakeUpCardDto> missCards = new ArrayList<MakeUpCardDto>();
        if (clockDtoList.size() > 0) {
            paramMap.put("tlkPerId", clockDtoList.get(0).getTlkPerId());
            List<MakeUpCard> cardList = this.makeUpCardMapper.selectListForPer(paramMap);
            Map<Date, List<MakeUpCard>> cardsMap = cardList.stream().collect(Collectors.groupingBy(OaBusinessBaseEntity::getStartTime));
            MakeUpCardDto makeUpCardDto = null;
            for (AttendClockDto attendClockDto : clockDtoList) {
                List<MakeUpCard> subCards;
                boolean apply;
                if (StrUtil.isEmpty((CharSequence)attendClockDto.getClockStart()) || attendClockDto.getLateMin() != null && attendClockDto.getLateMin() > 0) {
                    apply = false;
                    if (cardsMap.get(DateUtils.parseDate((Object)attendClockDto.getStartTime())) != null) {
                        subCards = cardsMap.get(DateUtils.parseDate((Object)attendClockDto.getStartTime()));
                        for (MakeUpCard subCard : subCards) {
                            if (!"1".equals(subCard.getCardType())) continue;
                            apply = true;
                        }
                    }
                    if (!apply) {
                        makeUpCardDto = new MakeUpCardDto();
                        makeUpCardDto.setCardTime(attendClockDto.getStartTime());
                        makeUpCardDto.setCardType("1");
                        missCards.add(makeUpCardDto);
                    }
                }
                if (!StrUtil.isEmpty((CharSequence)attendClockDto.getClockEnd()) && (attendClockDto.getLeaveEarly() == null || attendClockDto.getLeaveEarly() <= 0) || "2".equals(attendClockDto.getShiftType())) continue;
                apply = false;
                if (cardsMap.get(DateUtils.parseDate((Object)attendClockDto.getEndTime())) != null) {
                    subCards = cardsMap.get(DateUtils.parseDate((Object)attendClockDto.getEndTime()));
                    for (MakeUpCard subCard : subCards) {
                        if (!"2".equals(subCard.getCardType())) continue;
                        apply = true;
                    }
                }
                if (apply) continue;
                makeUpCardDto = new MakeUpCardDto();
                makeUpCardDto.setCardTime(attendClockDto.getEndTime());
                makeUpCardDto.setCardType("2");
                missCards.add(makeUpCardDto);
            }
            missCards = missCards.stream().sorted(Comparator.comparing(MakeUpCardDto::getCardTime)).collect(Collectors.toList());
        }
        return missCards;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.beginOfMonth((Date)DateUtils.addMonths((Date)DateUtils.getNowDate(), (int)-1)));
    }
}

