package com.bcxin.identify.util;

import com.github.pagehelper.PageInfo;

import java.io.Serializable;
import java.util.List;

public class PageInfoUtils<T> implements Serializable {
	 //结果集
    private List<T> data;
    
    private Integer pageNumber;
    
    private Integer pageSize;
    
    private Integer total;
    
    private Integer totalPage;

    private Object other;

    public PageInfoUtils() {
    	PageInfo pageInfo = new PageInfo();
    	this.pageSize = pageInfo.getPageSize();
    	this.pageNumber = pageInfo.getPageNum();
    	this.total = (int) pageInfo.getTotal();
    	this.totalPage = pageInfo.getPages();
    	
    }
    
    public PageInfoUtils(List<T> data) {
    	PageInfo pageInfo = new PageInfo(data);
    	this.data = data;
    	this.pageSize = pageInfo.getPageSize();
    	this.pageNumber = pageInfo.getPageNum();
    	this.total = (int) pageInfo.getTotal();
    	this.totalPage = pageInfo.getPages();
    }

	public List<T> getData() {
		return data;
	}

	public void setData(List<T> data) {
		this.data = data;
	}

	public Integer getPageNumber() {
		return pageNumber;
	}

	public void setPageNumber(Integer pageNumber) {
		this.pageNumber = pageNumber;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Integer getTotal() {
		return total;
	}

	public void setTotal(Integer total) {
		this.total = total;
	}

	public Integer getTotalPage() {
		return totalPage;
	}

	public void setTotalPage(Integer totalPage) {
		this.totalPage = totalPage;
	}

	public Object getOther() {
		return other;
	}

	public void setOther(Object other) {
		this.other = other;
	}
}
