package com.bcxin.identify.components.ringbuffers;


import com.bcxin.identify.business.service.LogBusinessrequestService;
import com.bcxin.identify.components.ringbuffers.datas.LoggingCacheObject;
import com.bcxin.identify.components.ringbuffers.events.ObjectEvent;
import com.lmax.disruptor.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingEventHandler implements EventHandler<ObjectEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessingEventHandler.class);

    private final LogBusinessrequestService logBusinessrequestService;

    public ProcessingEventHandler(LogBusinessrequestService logBusinessrequestService) {
        this.logBusinessrequestService = logBusinessrequestService;
    }

    @Override
    public void onEvent(ObjectEvent event, long l, boolean b) throws Exception {
        /*
        List<ServiceInstance> runtimeInstances =
                this.discoveryClient.getInstances("obpm-runtime");
        DistributeDesignCacheObject cacheEvent = (DistributeDesignCacheObject) event.getData();
        try {
            if (!CollectionUtils.isEmpty(runtimeInstances)) {
                String finalAppId = cacheEvent.getAppId();
                CompleteFurtherUtils.execute(runtimeInstances, (instance) -> {
                    doRefreshRequest(instance, finalAppId, cacheEvent.getData());
                });
            }
        } finally {
            logger.error("推送数据到obpm-runtime实例:{}-数据={}", runtimeInstances.size(), cacheEvent);
        }
         */

        LoggingCacheObject cacheEvent = (LoggingCacheObject) event.getData();
        this.logBusinessrequestService.save(cacheEvent.getBusinessType(), cacheEvent.getRequestStatus(), cacheEvent.getRequest(), cacheEvent.getResponse());
    }
}
