package com.bcxin.identify.caches;

import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;

@Data
public class CacheItem implements Serializable {
    private Object data;
    private Timestamp expiredTime;

    public boolean isExpired() {
        return expiredTime.before(Timestamp.from(Instant.now()));
    }

    public static CacheItem create(Object data,Timestamp expiredTime) {
        CacheItem cacheItem = new CacheItem();
        cacheItem.setData(data);
        cacheItem.setExpiredTime(expiredTime);

        return cacheItem;
    }
}
