package com.bcxin.identify.api.yehuo.controller;

import com.bcxin.identify.api.yehuo.dto.request.YehuoGetUserTokenRequest;
import com.bcxin.identify.api.yehuo.service.YehuoService;
import com.bcxin.identify.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * description：野火IM接口
 * author：linchunpeng
 * date：2023/10/16
 */
@RestController
@RequestMapping("/identify/api/yehuo")
@Slf4j
public class YehuoController {

    @Resource
    private YehuoService yehuoService;

    /**
     * description：获取用户token
     * author：linchunpeng
     * date：2023/10/16
     */
    @RequestMapping(value = "/get/token", method = {RequestMethod.POST})
    public Result getToken(@RequestBody @Valid YehuoGetUserTokenRequest request) {
        return yehuoService.getToken(request);
    }

}
