package com.bcxin.identify.api.util;


import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.identify.util.Result;
import com.bcxin.identify.util.common.JwtUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class IdentifyApiUtil {

    /**
     * <b> 百度人脸比对 </b>
     * @param jwtSecret 秘钥
     * @param oneImg 头像一
     * @param twoImg 头像二
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String matchFace(String jwtSecret, String oneImg, String twoImg) {
        if (StringUtils.isEmpty(oneImg)) {
            return JSONObject.toJSONString(Result.fail("oneImg不能为空！"));
        }
        if (StringUtils.isEmpty(twoImg)) {
            return JSONObject.toJSONString(Result.fail("twoImg不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("oneImg",oneImg);
        param.put("twoImg",twoImg);
        return requestAPI(IdentifyApiConst.BAIDU_MATCH_FACE, param, jwtSecret);
    }

    /**
     * <b> 百度人脸比对 </b>
     * @param jwtSecret 秘钥
     * @param oneImg 头像一
     * @param twoImg 头像二
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String parsingIdcard(String jwtSecret, String oneImg, String twoImg) {
        if (StringUtils.isEmpty(oneImg)) {
            return JSONObject.toJSONString(Result.fail("oneImg不能为空！"));
        }
        if (StringUtils.isEmpty(twoImg)) {
            return JSONObject.toJSONString(Result.fail("twoImg不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("oneImg",oneImg);
        param.put("twoImg",twoImg);
        return requestAPI(IdentifyApiConst.BAIDU_PARSING_IDCARD, param, jwtSecret);
    }

    /**
     * <b> 腾讯IM获取sig </b>
     * @param jwtSecret 秘钥
     * @param identifier 用户标识
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String getTencentSig(String jwtSecret, String identifier) {
        if (StringUtils.isEmpty(identifier)) {
            return JSONObject.toJSONString(Result.fail("identifier不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("identifier",identifier);
        return requestAPI(IdentifyApiConst.TENCENT_GET_SIG, param, jwtSecret);
    }

    /**
     * <b> 腾讯IM设置登陆用户资料 </b>
     * @param jwtSecret 秘钥
     * @param name 姓名
     * @param mobilePhone 手机
     * @param photoUrl 头像地址
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String createImPortrait(String jwtSecret
            , String name
            , String mobilePhone
            , String photoUrl
    ) {
        if (StringUtils.isEmpty(name)) {
            return JSONObject.toJSONString(Result.fail("name不能为空！"));
        }
        if (StringUtils.isEmpty(mobilePhone)) {
            return JSONObject.toJSONString(Result.fail("mobilePhone不能为空！"));
        }
        if (StringUtils.isEmpty(photoUrl)) {
            return JSONObject.toJSONString(Result.fail("photoUrl不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("name",name);
        param.put("mobilePhone",mobilePhone);
        param.put("photoUrl",photoUrl);
        return requestAPI(IdentifyApiConst.TENCENT_CREATE_IM_PORTRAIT, param, jwtSecret);
    }

    /**
     * <b> 腾讯IM圈定范围建群 </b>
     * @param jwtSecret 秘钥
     * @param members 用户标识列
     * @param groupName 群组名
     * @param groupType 群组类型
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String scopeImCreateGroup(String jwtSecret
            , String members
            , String groupName
            , String groupType
    ) {
        if (StringUtils.isEmpty(members)) {
            return JSONObject.toJSONString(Result.fail("members不能为空！"));
        }
        if (StringUtils.isEmpty(groupName)) {
            return JSONObject.toJSONString(Result.fail("groupName不能为空！"));
        }
        if (StringUtils.isEmpty(groupType)) {
            return JSONObject.toJSONString(Result.fail("groupType不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("members",members);
        param.put("groupName",groupName);
        param.put("groupType",groupType);
        return requestAPI(IdentifyApiConst.TENCENT_SCOPE_IM_CREATE_GROUP, param, jwtSecret);
    }

    /**
     * <b> 腾讯IM解散音视频房间 </b>
     * @param jwtSecret 秘钥
     * @param roomNo 房间号
     * @param region 服务区域标识
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String trtcVideoRoom(String jwtSecret
            , String roomNo
            , String region
    ) {
        if (StringUtils.isEmpty(roomNo)) {
            return JSONObject.toJSONString(Result.fail("roomNo不能为空！"));
        }
        if (StringUtils.isEmpty(region)) {
            return JSONObject.toJSONString(Result.fail("region不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("roomNo",roomNo);
        param.put("region",region);
        return requestAPI(IdentifyApiConst.TENCENT_TRTC_VIDEO_ROOM, param, jwtSecret);
    }

    /**
     * <b> 获取企业华为云会议管理资源 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String getHuaweiManageResource(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        return requestAPI(IdentifyApiConst.HUAWEI_GET_MANAGE_RESOURCE, param, jwtSecret);
    }

    /**
     * <b> 获取企业华为云会议管理资源 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @param restScheduleConf
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String buildHuaweiMeet(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
            , String restScheduleConf
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        if (StringUtils.isEmpty(restScheduleConf)) {
            return JSONObject.toJSONString(Result.fail("restScheduleConf不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        param.put("restScheduleConf",restScheduleConf);
        return requestAPI(IdentifyApiConst.HUAWEI_BUILD_MEET, param, jwtSecret);
    }

    /**
     * <b> 用户查询自己的信息 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String getHuaweiUserDetail(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        return requestAPI(IdentifyApiConst.HUAWEI_GET_USER_DETAIL, param, jwtSecret);
    }

    /**
     * <b> 获取企业华为专用云会议室 </b>
     * @param jwtSecret 秘钥
     * @param huaweiManageUserName 企业账号
     * @param huaweiManagePassWord 企业密码
     * @param offset
     * @param limit
     * @param searchKey
     * @param status
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String getHuaweiCloudMeetRoomList(String jwtSecret
            , String huaweiManageUserName
            , String huaweiManagePassWord
            , String offset
            , String limit
            , String searchKey
            , String status
    ) {
        if (StringUtils.isEmpty(huaweiManageUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiManageUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiManagePassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiManagePassWord不能为空！"));
        }
        if (StringUtils.isEmpty(offset)) {
            return JSONObject.toJSONString(Result.fail("offset不能为空！"));
        }
        if (StringUtils.isEmpty(limit)) {
            return JSONObject.toJSONString(Result.fail("limit不能为空！"));
        }
        if (StringUtils.isEmpty(status)) {
            return JSONObject.toJSONString(Result.fail("status不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiManageUserName",huaweiManageUserName);
        param.put("huaweiManagePassWord",huaweiManagePassWord);
        param.put("offset",offset);
        param.put("limit",limit);
        param.put("searchKey",searchKey);
        param.put("status",status);
        return requestAPI(IdentifyApiConst.HUAWEI_GET_CLOUD_MEET_ROOM_LIST, param, jwtSecret);
    }

    /**
     * <b> 修改用户云会议室 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @param vmrName
     * @param gustPwd
     * @param chairPwd
     * @param allowGustFirst
     * @param gustFirstNotice
     * @param vmrId
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String updateHuaweiCloudMemberVmr(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
            , String vmrName
            , String gustPwd
            , String chairPwd
            , boolean allowGustFirst
            , boolean gustFirstNotice
            , String vmrId
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        if (StringUtils.isEmpty(vmrName)) {
            return JSONObject.toJSONString(Result.fail("vmrName不能为空！"));
        }
        if (StringUtils.isEmpty(gustPwd)) {
            return JSONObject.toJSONString(Result.fail("gustPwd不能为空！"));
        }
        if (StringUtils.isEmpty(chairPwd)) {
            return JSONObject.toJSONString(Result.fail("chairPwd不能为空！"));
        }
        if (StringUtils.isEmpty(vmrId)) {
            return JSONObject.toJSONString(Result.fail("vmrId不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        param.put("vmrName",vmrName);
        param.put("gustPwd",gustPwd);
        param.put("chairPwd",chairPwd);
        param.put("allowGustFirst",allowGustFirst);
        param.put("gustFirstNotice",gustFirstNotice);
        param.put("vmrId",vmrId);
        return requestAPI(IdentifyApiConst.HUAWEI_UPDATE_CLOUD_MEMBER_VMR, param, jwtSecret);
    }

    /**
     * <b> 回收专用云会议室 </b>
     * @param jwtSecret 秘钥
     * @param huaweiManageUserName 企业账号
     * @param huaweiManagePassWord 企业密码
     * @param account
     * @param vmrIds
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String recycleFromMember(String jwtSecret
            , String huaweiManageUserName
            , String huaweiManagePassWord
            , String account
            , String vmrIds
    ) {
        if (StringUtils.isEmpty(huaweiManageUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiManageUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiManagePassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiManagePassWord不能为空！"));
        }
        if (StringUtils.isEmpty(account)) {
            return JSONObject.toJSONString(Result.fail("account不能为空！"));
        }
        if (StringUtils.isEmpty(vmrIds)) {
            return JSONObject.toJSONString(Result.fail("vmrIds不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiManageUserName",huaweiManageUserName);
        param.put("huaweiManagePassWord",huaweiManagePassWord);
        param.put("account",account);
        param.put("vmrIds",vmrIds);
        return requestAPI(IdentifyApiConst.HUAWEI_RECYCLE_FROM_MEMBER, param, jwtSecret);
    }

    /**
     * <b> 分配专用云会议室 </b>
     * @param jwtSecret 秘钥
     * @param huaweiManageUserName 企业账号
     * @param huaweiManagePassWord 企业密码
     * @param account
     * @param vmrIds
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String assignToMember(String jwtSecret
            , String huaweiManageUserName
            , String huaweiManagePassWord
            , String account
            , String vmrIds
    ) {
        if (StringUtils.isEmpty(huaweiManageUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiManageUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiManagePassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiManagePassWord不能为空！"));
        }
        if (StringUtils.isEmpty(account)) {
            return JSONObject.toJSONString(Result.fail("account不能为空！"));
        }
        if (StringUtils.isEmpty(vmrIds)) {
            return JSONObject.toJSONString(Result.fail("vmrIds不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiManageUserName",huaweiManageUserName);
        param.put("huaweiManagePassWord",huaweiManagePassWord);
        param.put("account",account);
        param.put("vmrIds",vmrIds);
        return requestAPI(IdentifyApiConst.HUAWEI_ASSIGN_TO_MEMBER, param, jwtSecret);
    }

    /**
     * <b> 删除专用云会议室 </b>
     * @param jwtSecret 秘钥
     * @param huaweiManageUserName 企业账号
     * @param huaweiManagePassWord 企业密码
     * @param account
     * @param vmrIds
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String deleteMemberVmr(String jwtSecret
            , String huaweiManageUserName
            , String huaweiManagePassWord
            , String account
            , String vmrIds
    ) {
        if (StringUtils.isEmpty(huaweiManageUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiManageUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiManagePassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiManagePassWord不能为空！"));
        }
        if (StringUtils.isEmpty(account)) {
            return JSONObject.toJSONString(Result.fail("account不能为空！"));
        }
        if (StringUtils.isEmpty(vmrIds)) {
            return JSONObject.toJSONString(Result.fail("vmrIds不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiManageUserName",huaweiManageUserName);
        param.put("huaweiManagePassWord",huaweiManagePassWord);
        param.put("account",account);
        param.put("vmrIds",vmrIds);
        return requestAPI(IdentifyApiConst.HUAWEI_DELETE_MEMBER_VMR, param, jwtSecret);
    }

    /**
     * <b> 分页查询用户云会议室 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @param restScheduleConf
     * @param offset
     * @param limit
     * @param searchKey
     * @param specialVmr
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String getHuaweiCloudMemberVmrList(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
            , String restScheduleConf
            , String offset
            , String limit
            , String searchKey
            , String specialVmr
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        if (StringUtils.isEmpty(restScheduleConf)) {
            return JSONObject.toJSONString(Result.fail("restScheduleConf不能为空！"));
        }
        if (StringUtils.isEmpty(offset)) {
            return JSONObject.toJSONString(Result.fail("offset不能为空！"));
        }
        if (StringUtils.isEmpty(limit)) {
            return JSONObject.toJSONString(Result.fail("limit不能为空！"));
        }
        if (StringUtils.isEmpty(specialVmr)) {
            return JSONObject.toJSONString(Result.fail("specialVmr不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        param.put("restScheduleConf",restScheduleConf);
        param.put("offset",offset);
        param.put("limit",limit);
        param.put("searchKey",searchKey);
        param.put("specialVmr",specialVmr);
        return requestAPI(IdentifyApiConst.HUAWEI_GET_CLOUD_MEMBER_VMR_LIST, param, jwtSecret);
    }

    /**
     * <b> 华为云鉴权 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String getHuaweiAccessToken(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        return requestAPI(IdentifyApiConst.HUAWEI_GET_ACCESS_TOKEN, param, jwtSecret);
    }

    /**
     * <b> 新增用户 </b>
     * @param jwtSecret 秘钥
     * @param huaweiManageUserName
     * @param huaweiManagePassWord
     * @param name
     * @param account
     * @param pwd
     * @param phone
     * @param sendNotify
     * @param country
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String addUser(String jwtSecret
            , String huaweiManageUserName
            , String huaweiManagePassWord
            , String name
            , String account
            , String pwd
            , String phone
            , String sendNotify
            , String country
    ) {
        if (StringUtils.isEmpty(huaweiManageUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiManageUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiManagePassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiManagePassWord不能为空！"));
        }
        if (StringUtils.isEmpty(name)) {
            return JSONObject.toJSONString(Result.fail("name不能为空！"));
        }
        if (StringUtils.isEmpty(account)) {
            return JSONObject.toJSONString(Result.fail("account不能为空！"));
        }
        if (StringUtils.isEmpty(pwd)) {
            return JSONObject.toJSONString(Result.fail("pwd不能为空！"));
        }
        if (StringUtils.isEmpty(phone)) {
            return JSONObject.toJSONString(Result.fail("phone不能为空！"));
        }
        if (StringUtils.isEmpty(sendNotify)) {
            return JSONObject.toJSONString(Result.fail("sendNotify不能为空！"));
        }
        if (StringUtils.isEmpty(country)) {
            return JSONObject.toJSONString(Result.fail("country不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiManageUserName",huaweiManageUserName);
        param.put("huaweiManagePassWord",huaweiManagePassWord);
        param.put("name",name);
        param.put("account",account);
        param.put("pwd",pwd);
        param.put("phone",phone);
        param.put("sendNotify",sendNotify);
        param.put("country",country);
        return requestAPI(IdentifyApiConst.HUAWEI_ADD_USER, param, jwtSecret);
    }

    /**
     * <b> 批量删除用户 </b>
     * @param jwtSecret 秘钥
     * @param huaweiManageUserName
     * @param huaweiManagePassWord
     * @param accounts
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String batchDeleteUser(String jwtSecret
            , String huaweiManageUserName
            , String huaweiManagePassWord
            , String accounts
    ) {
        if (StringUtils.isEmpty(huaweiManageUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiManageUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiManagePassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiManagePassWord不能为空！"));
        }
        if (StringUtils.isEmpty(accounts)) {
            return JSONObject.toJSONString(Result.fail("accounts不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiManageUserName",huaweiManageUserName);
        param.put("huaweiManagePassWord",huaweiManagePassWord);
        param.put("accounts",accounts);
        return requestAPI(IdentifyApiConst.HUAWEI_BATCH_DELETE_USER, param, jwtSecret);
    }

    /**
     * <b> 华为云查询会议列表 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @param userUUID
     * @param offset
     * @param limit
     * @param sortType
     * @param searchKey
     * @param queryConfMode
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String getHuaweiMeetList(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
            , String userUUID
            , String offset
            , String limit
            , String sortType
            , String searchKey
            , String queryConfMode
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        if (StringUtils.isEmpty(userUUID)) {
            return JSONObject.toJSONString(Result.fail("userUUID不能为空！"));
        }
        if (StringUtils.isEmpty(offset)) {
            return JSONObject.toJSONString(Result.fail("offset不能为空！"));
        }
        if (StringUtils.isEmpty(limit)) {
            return JSONObject.toJSONString(Result.fail("limit不能为空！"));
        }
        if (StringUtils.isEmpty(sortType)) {
            return JSONObject.toJSONString(Result.fail("sortType不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        param.put("userUUID",userUUID);
        param.put("offset",offset);
        param.put("limit",limit);
        param.put("sortType",sortType);
        param.put("searchKey",searchKey);
        param.put("queryConfMode",queryConfMode);
        return requestAPI(IdentifyApiConst.HUAWEI_GET_MEET_LIST, param, jwtSecret);
    }

    /**
     * <b> 获取录播文件列表 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @param userUUID
     * @param offset
     * @param limit
     * @param sortType
     * @param searchKey
     * @param startTime
     * @param endTime
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String getTranscribeFileList(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
            , String userUUID
            , String offset
            , String limit
            , String sortType
            , String searchKey
            , String startTime
            , String endTime
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        if (StringUtils.isEmpty(userUUID)) {
            return JSONObject.toJSONString(Result.fail("userUUID不能为空！"));
        }
        if (StringUtils.isEmpty(offset)) {
            return JSONObject.toJSONString(Result.fail("offset不能为空！"));
        }
        if (StringUtils.isEmpty(limit)) {
            return JSONObject.toJSONString(Result.fail("limit不能为空！"));
        }
        if (StringUtils.isEmpty(sortType)) {
            return JSONObject.toJSONString(Result.fail("sortType不能为空！"));
        }
        if (StringUtils.isEmpty(startTime)) {
            return JSONObject.toJSONString(Result.fail("startTime不能为空！"));
        }
        if (StringUtils.isEmpty(endTime)) {
            return JSONObject.toJSONString(Result.fail("endTime不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        param.put("userUUID",userUUID);
        param.put("offset",offset);
        param.put("limit",limit);
        param.put("sortType",sortType);
        param.put("searchKey",searchKey);
        param.put("startTime",startTime);
        param.put("endTime",endTime);
        return requestAPI(IdentifyApiConst.HUAWEI_GET_TRANSCRIBE_FILE_LIST, param, jwtSecret);
    }

    /**
     * <b> 批量删除录播文件 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @param confUUIDs
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String batchDeleteTranscribeFile(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
            , String confUUIDs
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        if (StringUtils.isEmpty(confUUIDs)) {
            return JSONObject.toJSONString(Result.fail("confUUIDs不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        param.put("confUUIDs",confUUIDs);
        return requestAPI(IdentifyApiConst.HUAWEI_BATCH_DELETE_TRANSCRIBE_FILE, param, jwtSecret);
    }

    /**
     * <b> 查询会议详情 </b>
     * @param jwtSecret 秘钥
     * @param huaweiUserName 个人账号
     * @param huaweiPassWord 个人密码
     * @param conferenceID
     * @param userUUID
     * @param offset
     * @param limit
     * @param searchKey
     * @author ZXF
     * @create 2021/01/31 0031 14:45
     * @version
     * @注意事项 </b>
     */
    public static String getHuaweiMeetDetail(String jwtSecret
            , String huaweiUserName
            , String huaweiPassWord
            , String conferenceID
            , String userUUID
            , String offset
            , String limit
            , String searchKey
    ) {
        if (StringUtils.isEmpty(huaweiUserName)) {
            return JSONObject.toJSONString(Result.fail("huaweiUserName不能为空！"));
        }
        if (StringUtils.isEmpty(huaweiPassWord)) {
            return JSONObject.toJSONString(Result.fail("huaweiPassWord不能为空！"));
        }
        if (StringUtils.isEmpty(conferenceID)) {
            return JSONObject.toJSONString(Result.fail("conferenceID不能为空！"));
        }
        if (StringUtils.isEmpty(userUUID)) {
            return JSONObject.toJSONString(Result.fail("userUUID不能为空！"));
        }
        Map<String, Object> param = new HashMap<>();
        param.put("huaweiUserName",huaweiUserName);
        param.put("huaweiPassWord",huaweiPassWord);
        param.put("conferenceID",conferenceID);
        param.put("userUUID",userUUID);
        param.put("offset",offset);
        param.put("limit",limit);
        param.put("searchKey",searchKey);
        return requestAPI(IdentifyApiConst.HUAWEI_GET_MEET_DETAIL, param, jwtSecret);
    }

    private static String requestAPI(String api, Map<String, Object> param, String jwtSecret){
        //加密生成token
        String token = JwtUtil.createJWT(param, jwtSecret);
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        return HttpUtil.post(IdentifyApiConst.PAYMENT_PLATFORM_URL + api, requestMap);
    }
}
