/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.utilities;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static List<Class<?>> getAllAssignedClass(Class<?> cls) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        for (Class<?> c : ClassUtil.getClasses(cls)) {
            if (!cls.isAssignableFrom(c) || cls.equals(c)) continue;
            classes.add(c);
        }
        return classes;
    }

    public static List<Class<?>> getClasses(Class<?> cls) throws IOException, ClassNotFoundException {
        String pk = cls.getPackage().getName();
        List<String> classNames = ClassUtil.getClassName(pk, true);
        ArrayList classes = new ArrayList();
        for (String className : classNames) {
            if (className.endsWith(".class")) {
                className = className.substring(0, className.length() - 6);
                className = className.substring(className.lastIndexOf("/") + 1, className.length());
            }
            classes.add(Class.forName(className));
        }
        return classes;
    }

    private static List<Class<?>> getClasses(File dir, String pk) throws ClassNotFoundException {
        System.out.println(dir.getAbsolutePath());
        ArrayList classes = new ArrayList();
        if (!dir.exists()) {
            return classes;
        }
        for (File f : dir.listFiles()) {
            String name;
            if (f.isDirectory()) {
                classes.addAll(ClassUtil.getClasses(f, pk + "." + f.getName()));
            }
            if (!(name = f.getName()).endsWith(".class")) continue;
            classes.add(Class.forName(pk + "." + name.substring(0, name.length() - 6)));
        }
        return classes;
    }

    public static List<String> getClassName(String packageName, boolean childPackage) {
        String packagePath;
        List<String> fileNames = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null) {
            String type = url.getProtocol();
            if (type.equals("file")) {
                fileNames = ClassUtil.getClassNameByFile(url.getPath(), null, childPackage);
            } else if (type.equals("jar")) {
                fileNames = ClassUtil.getClassNameByJar(url.getPath(), childPackage);
            }
        } else {
            fileNames = ClassUtil.getClassNameByJars(((URLClassLoader)loader).getURLs(), packagePath, childPackage);
        }
        return fileNames;
    }

    private static List<String> getClassNameByFile(String filePath, List<String> className, boolean childPackage) {
        File[] childFiles;
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        for (File childFile : childFiles = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(ClassUtil.getClassNameByFile(childFile.getPath(), myClassName, childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            if (childFilePath.indexOf("\\classes") >= 0 || childFilePath.indexOf("/classes") >= 0) {
                int start = childFilePath.indexOf("\\classes");
                if (start == -1) {
                    start = childFilePath.indexOf("/classes");
                }
                childFilePath = childFilePath.substring(start + 9, childFilePath.lastIndexOf("."));
            }
            childFilePath = childFilePath.replace("\\", ".");
            childFilePath = childFilePath.replace("/", ".");
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private static List<String> getClassNameByJar(String jarPath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(entryName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myClassName;
    }

    private static List<String> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(ClassUtil.getClassNameByJar(jarPath, childPackage));
            }
        }
        return myClassName;
    }
}

