/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import io.netty.util.internal.StringUtil;
import java.util.Base64;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class LinkMessageContent
extends MessageContent {
    private String title;
    private String contentDigest;
    private String url;
    private String thumbnailUrl;

    public LinkMessageContent() {
    }

    public LinkMessageContent(String title, String url) {
        this.title = title;
        this.url = url;
    }

    public String getContentDigest() {
        return this.contentDigest;
    }

    public void setContentDigest(String contentDigest) {
        this.contentDigest = contentDigest;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @Override
    public int getContentType() {
        return 8;
    }

    @Override
    public int getPersistFlag() {
        return 3;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setSearchableContent(this.title);
        JSONObject objWrite = new JSONObject();
        objWrite.put((Object)"d", (Object)this.contentDigest);
        objWrite.put((Object)"u", (Object)this.url);
        objWrite.put((Object)"t", (Object)this.thumbnailUrl);
        payload.setBase64edData(Base64.getEncoder().encodeToString(objWrite.toString().getBytes()));
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
        this.title = payload.getSearchableContent();
        try {
            if (!StringUtil.isNullOrEmpty((String)payload.getBase64edData())) {
                JSONObject jsonObject = (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(payload.getBase64edData())));
                this.contentDigest = (String)jsonObject.get((Object)"d");
                this.url = (String)jsonObject.get((Object)"u");
                this.thumbnailUrl = (String)jsonObject.get((Object)"t");
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

