/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import io.netty.util.internal.StringUtil;
import java.util.Base64;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CardMessageContent
extends MessageContent {
    private int type;
    private String target;
    private String name;
    private String displayName;
    private String portrait;
    private String from;

    public CardMessageContent() {
    }

    public CardMessageContent(int type, String target, String displayName, String portrait, String from) {
        this.type = type;
        this.target = target;
        this.displayName = displayName;
        this.portrait = portrait;
        this.from = from;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPortrait() {
        return this.portrait;
    }

    public void setPortrait(String portrait) {
        this.portrait = portrait;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    @Override
    public int getContentType() {
        return 10;
    }

    @Override
    public int getPersistFlag() {
        return 3;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setContent(this.target);
        JSONObject objWrite = new JSONObject();
        objWrite.put((Object)"t", (Object)this.type);
        objWrite.put((Object)"n", (Object)this.name);
        objWrite.put((Object)"d", (Object)this.displayName);
        objWrite.put((Object)"p", (Object)this.portrait);
        objWrite.put((Object)"f", (Object)this.from);
        payload.setBase64edData(Base64.getEncoder().encodeToString(objWrite.toString().getBytes()));
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
        this.target = payload.getContent();
        try {
            if (!StringUtil.isNullOrEmpty((String)payload.getBase64edData())) {
                JSONObject jsonObject = (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(payload.getBase64edData())));
                this.type = (Integer)jsonObject.get((Object)"t");
                this.name = (String)jsonObject.get((Object)"n");
                this.displayName = (String)jsonObject.get((Object)"d");
                this.portrait = (String)jsonObject.get((Object)"p");
                this.from = (String)jsonObject.get((Object)"f");
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

