/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.pojos.Conversation;
import cn.wildfirechat.pojos.InputAddFriendRequest;
import cn.wildfirechat.pojos.InputAddGroupMember;
import cn.wildfirechat.pojos.InputDismissGroup;
import cn.wildfirechat.pojos.InputHandleFriendRequest;
import cn.wildfirechat.pojos.InputKickoffGroupMember;
import cn.wildfirechat.pojos.InputModifyGroupInfo;
import cn.wildfirechat.pojos.InputOutputDomainInfo;
import cn.wildfirechat.pojos.InputOutputDomainInfoList;
import cn.wildfirechat.pojos.InputQuitGroup;
import cn.wildfirechat.pojos.InputStringValue;
import cn.wildfirechat.pojos.InputTransferGroup;
import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.pojos.OutputGroupMemberList;
import cn.wildfirechat.pojos.OutputStringList;
import cn.wildfirechat.pojos.OutputUserInfoList;
import cn.wildfirechat.pojos.PojoGroup;
import cn.wildfirechat.pojos.PojoGroupInfo;
import cn.wildfirechat.pojos.PojoGroupInfoList;
import cn.wildfirechat.pojos.PojoGroupMember;
import cn.wildfirechat.pojos.RecallMessageData;
import cn.wildfirechat.pojos.SendMessageData;
import cn.wildfirechat.pojos.SendMessageResult;
import cn.wildfirechat.pojos.UpdateMessageContentData;
import cn.wildfirechat.pojos.mesh.PojoPublishMessageReq;
import cn.wildfirechat.pojos.mesh.PojoSearchUserReq;
import cn.wildfirechat.pojos.mesh.PojoSearchUserRes;
import cn.wildfirechat.pojos.mesh.PojoUserConferenceEvent;
import cn.wildfirechat.pojos.mesh.PojoUserConferenceRequest;
import cn.wildfirechat.pojos.mesh.PojoUserConferenceResponse;
import cn.wildfirechat.sdk.GroupAdmin;
import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.AdminHttpUtils;
import java.util.List;

public class MeshAdmin {
    public static IMResult<Void> createDomain(InputOutputDomainInfo domainInfo) throws Exception {
        String path = "/admin/domain/create";
        return AdminHttpUtils.httpJsonPost(path, domainInfo, Void.class);
    }

    public static IMResult<InputOutputDomainInfo> getDomain(String domainId) throws Exception {
        String path = "/admin/domain/get";
        InputStringValue inputId = new InputStringValue();
        inputId.setValue(domainId);
        return AdminHttpUtils.httpJsonPost(path, inputId, InputOutputDomainInfo.class);
    }

    public static IMResult<Void> deleteDomain(String domainId) throws Exception {
        String path = "/admin/domain/destroy";
        InputStringValue inputId = new InputStringValue();
        inputId.setValue(domainId);
        return AdminHttpUtils.httpJsonPost(path, inputId, Void.class);
    }

    public static IMResult<InputOutputDomainInfoList> getAllDomain() throws Exception {
        String path = "/admin/domain/list";
        return AdminHttpUtils.httpJsonPost(path, null, InputOutputDomainInfoList.class);
    }

    public static IMResult<OutputUserInfoList> getBatchUserInfos(List<String> userIds) throws Exception {
        String path = "/admin/user/batch_get_infos";
        OutputStringList getUserInfo = new OutputStringList(userIds);
        return AdminHttpUtils.httpJsonPost(path, getUserInfo, OutputUserInfoList.class);
    }

    public static IMResult<PojoSearchUserRes> searchUser(String keyword, int searchType, int page) throws Exception {
        String path = "/admin/user/search_user";
        PojoSearchUserReq req = new PojoSearchUserReq();
        req.keyword = keyword;
        req.searchType = searchType;
        req.page = page;
        return AdminHttpUtils.httpJsonPost(path, req, PojoSearchUserRes.class);
    }

    public static IMResult<Void> sendFriendRequest(String userId, String targetId, String reason) throws Exception {
        String path = "/admin/friend/send_request";
        InputAddFriendRequest input = new InputAddFriendRequest();
        input.setUserId(userId);
        input.setFriendUid(targetId);
        input.setReason(reason);
        input.setForce(false);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<Void> handleFriendRequest(String userId, String targetId, int status) throws Exception {
        String path = "/admin/friend/handle_send_request";
        InputHandleFriendRequest input = new InputHandleFriendRequest();
        input.setUserId(userId);
        input.setFriendUid(targetId);
        input.setStatus(status);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<SendMessageResult> sendMessage(String sender, Conversation conversation, MessagePayload payload, List<String> toUsers) throws Exception {
        String path = "/admin/message/send";
        SendMessageData messageData = new SendMessageData();
        messageData.setSender(sender);
        messageData.setConv(conversation);
        messageData.setPayload(payload);
        messageData.setToUsers(toUsers);
        messageData.setMeshMessage(true);
        if (payload.getType() == 1 && (payload.getSearchableContent() == null || payload.getSearchableContent().isEmpty())) {
            System.out.println("Payload\u9519\u8bef\uff0cPayload\u683c\u5f0f\u5e94\u8be5\u8ddf\u5ba2\u6237\u7aef\u6d88\u606fencode\u51fa\u6765\u7684Payload\u5bf9\u9f50\uff0c\u8fd9\u6837\u5ba2\u6237\u7aef\u624d\u80fd\u6b63\u786e\u8bc6\u522b\u3002\u6bd4\u5982\u6587\u672c\u6d88\u606f\uff0c\u6587\u672c\u9700\u8981\u653e\u5230searchableContent\u5c5e\u6027\u3002\u8bf7\u4e0e\u5ba2\u6237\u7aef\u540c\u4e8b\u786e\u8ba4Payload\u7684\u683c\u5f0f\uff0c\u6216\u5219\u53bb https://gitee.com/wfchat/android-chat/tree/master/client/src/main/java/cn/wildfirechat/message \u627e\u5230\u6d88\u606fencode\u7684\u5b9e\u73b0\u65b9\u6cd5\uff01");
        }
        return AdminHttpUtils.httpJsonPost(path, messageData, SendMessageResult.class);
    }

    public static IMResult<SendMessageResult> publishMessage(SendMessageData messageData, List<String> receivers) throws Exception {
        String path = "/admin/message/publish";
        PojoPublishMessageReq req = new PojoPublishMessageReq();
        req.messageData = messageData;
        req.receivers = receivers;
        return AdminHttpUtils.httpJsonPost(path, req, SendMessageResult.class);
    }

    public static IMResult<String> recallMessage(String operator, long messageId) throws Exception {
        String path = "/admin/message/recall";
        RecallMessageData req = new RecallMessageData();
        req.setOperator(operator);
        req.setMessageUid(messageId);
        req.setUserRecall(true);
        return AdminHttpUtils.httpJsonPost(path, req, String.class);
    }

    public static IMResult<Void> updateMessageContent(String operator, long messageUid, MessagePayload payload, boolean distribute) throws Exception {
        String path = "/admin/message/update";
        UpdateMessageContentData updateMessageContentData = new UpdateMessageContentData();
        updateMessageContentData.setOperator(operator);
        updateMessageContentData.setMessageUid(messageUid);
        updateMessageContentData.setPayload(payload);
        updateMessageContentData.setDistribute(distribute ? 1 : 0);
        updateMessageContentData.setUpdateTimestamp(0);
        updateMessageContentData.setMeshLocal(1);
        return AdminHttpUtils.httpJsonPost(path, updateMessageContentData, Void.class);
    }

    public static IMResult<Void> syncGroup(PojoGroupInfo group_info, List<PojoGroupMember> members) throws Exception {
        String path = "/admin/mesh/group_sync";
        PojoGroup pojoGroup = new PojoGroup();
        pojoGroup.setGroup_info(group_info);
        pojoGroup.setMembers(members);
        return AdminHttpUtils.httpJsonPost(path, pojoGroup, Void.class);
    }

    public static IMResult<PojoGroupInfo> getGroupInfo(String groupId) throws Exception {
        return GroupAdmin.getGroupInfo(groupId);
    }

    public static IMResult<OutputGroupMemberList> getGroupMembers(String groupId) throws Exception {
        return GroupAdmin.getGroupMembers(groupId);
    }

    public static IMResult<Void> addGroupMembers(String operator, String groupId, List<PojoGroupMember> groupMembers, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/admin/group/member/add";
        InputAddGroupMember addGroupMember = new InputAddGroupMember();
        addGroupMember.setGroup_id(groupId);
        addGroupMember.setMembers(groupMembers);
        addGroupMember.setOperator(operator);
        addGroupMember.setTo_lines(to_lines);
        addGroupMember.setNotify_message(notify_message);
        addGroupMember.setMeshMessage(true);
        return AdminHttpUtils.httpJsonPost(path, addGroupMember, Void.class);
    }

    public static IMResult<PojoGroupInfoList> batchGroupInfos(List<String> groupIds) throws Exception {
        return GroupAdmin.batchGroupInfos(groupIds);
    }

    public static IMResult<Void> quitGroup(String operator, String groupId, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/admin/group/member/quit";
        InputQuitGroup quitGroup = new InputQuitGroup();
        quitGroup.setGroup_id(groupId);
        quitGroup.setOperator(operator);
        quitGroup.setTo_lines(to_lines);
        quitGroup.setNotify_message(notify_message);
        quitGroup.setMeshMessage(true);
        return AdminHttpUtils.httpJsonPost(path, quitGroup, Void.class);
    }

    public static IMResult<Void> dismissGroup(String operator, String groupId, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/admin/group/del";
        InputDismissGroup dismissGroup = new InputDismissGroup();
        dismissGroup.setOperator(operator);
        dismissGroup.setGroup_id(groupId);
        dismissGroup.setTo_lines(to_lines);
        dismissGroup.setNotify_message(notify_message);
        dismissGroup.setMeshMessage(true);
        return AdminHttpUtils.httpJsonPost(path, dismissGroup, Void.class);
    }

    public static IMResult<Void> kickoffGroupMembers(String operator, String groupId, List<String> groupMemberIds, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/admin/group/member/del";
        InputKickoffGroupMember kickoffGroupMember = new InputKickoffGroupMember();
        kickoffGroupMember.setGroup_id(groupId);
        kickoffGroupMember.setMembers(groupMemberIds);
        kickoffGroupMember.setOperator(operator);
        kickoffGroupMember.setTo_lines(to_lines);
        kickoffGroupMember.setMeshMessage(true);
        kickoffGroupMember.setNotify_message(notify_message);
        return AdminHttpUtils.httpJsonPost(path, kickoffGroupMember, Void.class);
    }

    public static IMResult<Void> transferGroup(String operator, String groupId, String newOwner, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/admin/group/transfer";
        InputTransferGroup transferGroup = new InputTransferGroup();
        transferGroup.setGroup_id(groupId);
        transferGroup.setNew_owner(newOwner);
        transferGroup.setOperator(operator);
        transferGroup.setTo_lines(to_lines);
        transferGroup.setNotify_message(notify_message);
        transferGroup.setMeshMessage(true);
        return AdminHttpUtils.httpJsonPost(path, transferGroup, Void.class);
    }

    public static IMResult<Void> modifyGroupInfo(String operator, String groupId, int type, String value, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/admin/group/modify";
        InputModifyGroupInfo modifyGroupInfo = new InputModifyGroupInfo();
        modifyGroupInfo.setGroup_id(groupId);
        modifyGroupInfo.setOperator(operator);
        modifyGroupInfo.setTo_lines(to_lines);
        modifyGroupInfo.setType(type);
        modifyGroupInfo.setValue(value);
        modifyGroupInfo.setNotify_message(notify_message);
        modifyGroupInfo.setMeshMessage(true);
        return AdminHttpUtils.httpJsonPost(path, modifyGroupInfo, Void.class);
    }

    public static IMResult<PojoUserConferenceResponse> userConferenceRequest(String clientID, String fromUser, String request, long sessionId, String roomId, String data, boolean advanced) throws Exception {
        String path = "/admin/conference/user_request";
        PojoUserConferenceRequest conferenceRequest = new PojoUserConferenceRequest();
        conferenceRequest.clientID = clientID;
        conferenceRequest.fromUser = fromUser;
        conferenceRequest.request = request;
        conferenceRequest.sessionId = sessionId;
        conferenceRequest.roomId = roomId;
        conferenceRequest.data = data;
        conferenceRequest.advanced = advanced;
        return AdminHttpUtils.httpJsonPost(path, conferenceRequest, PojoUserConferenceResponse.class);
    }

    public static IMResult<Void> userConferenceEvent(String data, String userId, String clientId, boolean isRobot) throws Exception {
        String path = "/admin/conference/user_event";
        PojoUserConferenceEvent event = new PojoUserConferenceEvent();
        event.data = data;
        event.userId = userId;
        event.clientId = clientId;
        event.isRobot = isRobot;
        return AdminHttpUtils.httpJsonPost(path, event, Void.class);
    }
}

