package com.bcxin.runtime.apis.components;

import cn.myapps.components.MessageProvider;
import cn.myapps.components.requests.CreateMessageRequest;
import com.bcxin.runtime.domain.messages.commands.BatchCreateMessageCommand;
import com.bcxin.runtime.domain.messages.commands.CreateMessageCommand;
import com.bcxin.runtime.domain.messages.services.MessageService;
import com.bcxin.saas.core.enums.MessageType;
import com.bcxin.saas.core.enums.ReceiverType;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

@Primary
@Component
public class MessageProviderImpl implements MessageProvider {
    private final MessageService messageService;

    public MessageProviderImpl(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public void dispatch(String senderId, MessageType messageType, String title, String content,
                         ReceiverType receiverType, String receiver,
                         String businessNumber, String uniqueId) {
        this.messageService.dispatch(
                CreateMessageCommand.create(
                senderId, messageType, title,
                content, receiverType, receiver, Collections.emptyMap(),
                businessNumber, uniqueId));
    }

    @Override
    public void dispatch(CreateMessageRequest request) {
        this.messageService.dispatch(
                CreateMessageCommand.create(
                        request.getSenderId(),
                        request.getMessageType(),
                        request.getTitle(),
                        request.getContent(),
                        request.getReceiverType(), request.getReceiver(), Collections.emptyMap(),
                        request.getBusinessNumber(),
                        request.getUniqueId()
                ));
    }

    @Override
    public void dispatch(Collection<CreateMessageRequest> requests) {
        this.messageService.dispatch(
                BatchCreateMessageCommand.create(requests.stream().map(ii -> {
                    return
                            CreateMessageCommand.create(ii.getSenderId(), ii.getMessageType(), ii.getTitle(),
                                    ii.getContent(), ii.getReceiverType(), ii.getReceiver(), Collections.emptyMap(),
                                    ii.getBusinessNumber(),
                                    ii.getUniqueId());
                }).collect(Collectors.toList()))
        );
    }
}
