package com.bcxin.saas.domains.readers;

import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.domains.dtos.RbacEmployeePermitAppDTO;
import com.bcxin.saas.domains.dtos.RbacEmployeePermitOptionDTO;
import com.bcxin.saas.domains.dtos.RbacQueryDTO;
import com.bcxin.saas.domains.entities.RbacAppEntity;
import com.bcxin.saas.domains.repositories.RbacAppRepository;
import com.bcxin.saas.domains.repositories.RbacOptionRepository;
import io.jsonwebtoken.lang.Collections;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RbacDbReaderImpl implements RbacDbReader{
    //基础服务应用编码
    private static final String BASE_SERVICE_APP_CODE = "__zidingyiyingyongPTJCGN";
    //基础服务所有应用菜单编码
    private static final String WORKSPACE_OPTION_CODE = "__ZiDingYiCaiDanSuoYouYingYong";

    private DistributedCacheProvider distributedCacheProvider;
    private RbacAppRepository rbacAppRepository;
    private RbacOptionRepository rbacOptionRepository;

    public RbacDbReaderImpl(DistributedCacheProvider distributedCacheProvider, RbacAppRepository rbacAppRepository, RbacOptionRepository rbacOptionRepository){
        this.distributedCacheProvider = distributedCacheProvider;
        this.rbacAppRepository = rbacAppRepository;
        this.rbacOptionRepository = rbacOptionRepository;
    }

    @Override
    public RbacEmployeePermitAppDTO getPermitApps(RbacQueryDTO rbacQueryDTO) {
        RbacEmployeePermitAppDTO permitAppDTO = new RbacEmployeePermitAppDTO();
        //基础服务菜单
        //目前只有web端需要查询基础功能菜单
        Set<String> baseServiceOptionsSet = null;
        if(!rbacQueryDTO.isMobile()){
            rbacQueryDTO.setAppId(BASE_SERVICE_APP_CODE);
            baseServiceOptionsSet = getUserPermitOptions(rbacQueryDTO);
            permitAppDTO.setBaseServiceOptions(baseServiceOptionsSet);
        }

        //如果是手机端 或者 web端的基础服务里面有所有应用菜单，需要查询授权的应用
        if(rbacQueryDTO.isMobile() || (baseServiceOptionsSet != null && baseServiceOptionsSet.contains(WORKSPACE_OPTION_CODE))){
            List<RbacAppEntity> appList = getWorkspaceApps(rbacQueryDTO);
            permitAppDTO.setWorkspaceApps(appList);
        }

        return permitAppDTO;

    }

    private List<RbacAppEntity> getWorkspaceApps(RbacQueryDTO rbacQueryDTO) {
        List<RbacAppEntity> permitsAppSet = rbacAppRepository.findPermitApps(rbacQueryDTO);
        //剔除掉基础应用
        List<RbacAppEntity> appList = permitsAppSet.stream().filter(ix->!ix.getAppCode().equals(BASE_SERVICE_APP_CODE))
                .collect(Collectors.toList());
        return appList;
    }

    private Set<String> getUserPermitOptions(RbacQueryDTO rbacQueryDTO) {
        Set<String> entity = rbacOptionRepository.findPermitOptions(rbacQueryDTO);
        if(Collections.isEmpty(entity)){
            return new HashSet<>();
        }
        return entity;
    }

    @Override
    public RbacEmployeePermitOptionDTO getPermitOptions(RbacQueryDTO rbacQueryDTO) {
        RbacEmployeePermitOptionDTO permitAppVO = new RbacEmployeePermitOptionDTO();
        Set<String> permitOptionsSet = getUserPermitOptions(rbacQueryDTO);
        permitAppVO.setAppId(rbacQueryDTO.getAppId());
        permitAppVO.setOptions(permitOptionsSet);
        return permitAppVO;
    }
}
